/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_SCENE_IO_TASK_H_
#define _GB2_WORKFLOW_SCENE_IO_TASK_H_

#include <workflow_support/WorkflowIOTasks.h>

namespace GB2 {
class WorkflowScene;
using namespace Workflow;

class ExportWorkflowSceneTask : public Task {
    Q_OBJECT
public:
    ExportWorkflowSceneTask(WorkflowScene* scene, const QString& url);
    virtual void run(){
        assert( false );
    };
private:
    const QString url;
    WorkflowScene* scene;
};

class SaveWorkflowSceneTask : public SaveWorkflowTask {
    Q_OBJECT
public:
    SaveWorkflowSceneTask(WorkflowScene* scene, const Metadata& meta);
    Task::ReportResult report();
private:
    QPointer<WorkflowScene> scene;
};

class LoadWorkflowSceneTask : public LoadWorkflowTask {
    Q_OBJECT
public:
    LoadWorkflowSceneTask(WorkflowScene* scene, Metadata* meta, const QString& url);
    Task::ReportResult report();
    WorkflowScene* getScene() const {return scene;}
private:
    WorkflowScene* scene;
};

} //namespace
#endif
