/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifdef SW2_BUILD_WITH_CUDA

#ifndef _SW_CUDA_CPP_H
#define _SW_CUDA_CPP_H

#include <core_api/LRegion.h>

struct resType
{
    GB2::LRegion reg;
    int score;
};

class sw_cuda_cpp {
public:    
    typedef int ScoreType;

    QList<resType> launch(const char * seqLib, int seqLibLength, ScoreType* queryProfile, ScoreType qProfLen, int queryLength, ScoreType gapOpen, ScoreType gapExtension, ScoreType maxScore);    
    static quint64 estimateNeededGpuMemory( int seqLibLength, ScoreType qProfLen, int queryLength );	
	static const int MAX_BLOCKS_NUMBER;	
	static const int MAX_SHARED_VECTOR_LENGTH;	
};

#endif

#endif //SW2_BUILD_WITH_CUDA
