##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (smith_waterman.pri)
include (../../ugene_globals.pri)

UGENE_RELATIVE_DESTDIR = 'plugins'

TEMPLATE = lib
CONFIG +=qt dll thread debug_and_release 
QT += network xml script
DEFINES+= QT_DLL
INCLUDEPATH += src _tmp ../../core/src  ../../core/_tmp 

LIBS += -L../../_release -lcore

!debug_and_release|build_pass {
    CONFIG(debug, debug|release) {
        TARGET = smith_watermand
        DEFINES+=_DEBUG
        CONFIG +=console
        DESTDIR=../../_debug/plugins
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS -= -L../../_release -lcore
        LIBS += -L../../_debug -lcored
    }
    CONFIG(release, debug|release) {
        DEFINES+=NDEBUG
        TARGET = smith_waterman
        DESTDIR=../../_release/plugins
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release
    }
}


UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc


win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3

    QMAKE_MSVC_PROJECT_NAME=plugin_smith_waterman
}

#adding SSE2 gcc compiler flag if building on SSE2 capable CPU

use_sse2() {
    !win32 {
        QMAKE_CXXFLAGS += -msse2
        QMAKE_CFLAGS_DEBUG += -msse2
        QMAKE_CFLAGS_RELEASE += -msse2
    }
    DEFINES += SW2_BUILD_WITH_SSE2
}

#adding CUDA specific parameters
use_cuda() {

    LIBS += -L$$UGENE_CUDA_LIB_DIR -lcudart
    INCLUDEPATH += $$UGENE_CUDA_INC_DIR

    SW2_NVCC_FLAGS =

#TODO: win 64?
    !win32  {
        SW2_NVCC_FLAGS += -Xcompiler -fPIC
    }
    
    SW2_CUDA_LIBS += -lcudart
    SW2_CUDA_FILES += src/sw_cuda.cu

#workaround for nmake bug: nvcc failes with an internal error when launched from Makefile by nvcc
    win32 {
        SW2_CUDA_NULL_REDIRECT = > nul
    } else {
        SW2_CUDA_NULL_REDIRECT = 
    }
#manually convert INCLUDEPATH:
    SW2_CUDA_INCLUDEPATH =
    for(path, INCLUDEPATH) {
        SW2_CUDA_INCLUDEPATH += -I$${path}
    }
    for(path, QMAKE_INCDIR) {
        SW2_CUDA_INCLUDEPATH += -I$${path}
    }
#    message( $$SW2_CUDA_INCLUDEPATH )

    nvzz.output = $$OBJECTS_DIR/${QMAKE_FILE_BASE}$$QMAKE_EXT_OBJ
    nvzz.commands = $$UGENE_NVCC $$SW2_NVCC_FLAGS -c -I$$UGENE_CUDA_INC_DIR $$SW2_CUDA_INCLUDEPATH -I$$QMAKE_INCDIR_QT \
                    -L$$UGENE_CUDA_LIB_DIR $$SW2_CUDA_LIBS \
                    -o ${QMAKE_FILE_OUT} \
                    ${QMAKE_FILE_NAME} \
                    $$SW2_CUDA_NULL_REDIRECT
    nvzz.depend_command = 
    nvzz.input = SW2_CUDA_FILES

    QMAKE_EXTRA_COMPILERS += nvzz

    DEFINES += SW2_BUILD_WITH_CUDA
}

#adding ATI Stream specific parameters
use_atistream() {

    LIBS += -L$$UGENE_ATIBROOK_LIB_DIR -lbrook
    INCLUDEPATH += $$UGENE_ATIBROOK_INC_DIR
    
    SW2_ATIBROOK_FILES += src/sw_atistream.br

#todo: atomatic generate file names for include
    HEADERS += src/brookgenfiles/sw_atistream.h
    SOURCES += src/brookgenfiles/sw_atistream.cpp 

    brzz.output = src/brookgenfiles/${QMAKE_FILE_BASE}.cpp
    brzz.commands = \"$$UGENE_BRCC\" \
                    -o src/brookgenfiles/${QMAKE_FILE_BASE} \
                    ${QMAKE_FILE_NAME} 
    brzz.input = SW2_ATIBROOK_FILES
    brzz.CONFIG += no_link

    QMAKE_EXTRA_COMPILERS += brzz

    DEFINES += SW2_BUILD_WITH_ATISTREAM
}

unix {
    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
