/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_PROJECT_VIEW_ITEMS_H_
#define _GB2_EXPORT_PROJECT_VIEW_ITEMS_H_

#include <core_api/core_api.h>

#include <QtGui/QAction>
#include <QtGui/QMenu>

namespace GB2 {

class ExportProjectViewItemsContoller : public QObject {
    Q_OBJECT
public:
    ExportProjectViewItemsContoller(QObject* p);

private slots:
    void sl_addToProjectViewMenu(QMenu&);

    void sl_saveSequencesToSequenceFormat();
    void sl_saveSequencesAsAlignment();
    void sl_saveAlignmentAsSequences();
    void sl_importAnnotationsFromCSV();
    void sl_exportChromatogramToSCF();

private:
    void addExportMenu(QMenu& m);
    void addImportMenu(QMenu& m);

    QAction* exportSequencesToSequenceFormatAction;
    QAction* exportSequencesAsAlignmentAction;
    QAction* exportAlignmentAsSequencesAction;
    QAction* importAnnotationsFromCSVAction;
    QAction* exportDNAChromatogramAction;

};

}//namespace

#endif
