/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/GObject.h>
#include <gobjects/DNASequenceObject.h>

#include "ImportQualityScoresTask.h"
#include "DNAExportPluginTests.h"

namespace GB2 {

#define URL_ATTR "url"
#define SEQLIST_ATTR "seq-list"

void GTest_ImportPhredQualityScoresTask::init(XMLTestFormat *tf, const QDomElement& el) {
    Q_UNUSED(tf);

    QString buf = el.attribute(SEQLIST_ATTR);
    if (buf.isEmpty()) {
        failMissingValue(SEQLIST_ATTR);
        return;
    }

    seqNameList = buf.split(",");
    if (seqNameList.count() == 0) {
        stateInfo.setError("No sequences are found.");
        return;
    }

    fileName = el.attribute(URL_ATTR);
    if (fileName.isEmpty()) {
        failMissingValue(URL_ATTR);
    }
    
    fileName = env->getVar("COMMON_DATA_DIR") + "/" + fileName;

}

void GTest_ImportPhredQualityScoresTask::prepare() {
    
    foreach(const QString& seqName, seqNameList) {
        GObject *obj = getContext<GObject>(this, seqName);
        if(obj==NULL){
            stateInfo.setError(QString("wrong sequence name: %1").arg(seqName));
            return;
        }

        DNASequenceObject * mySequence = qobject_cast<DNASequenceObject*>(obj);
        if(mySequence == NULL){
            stateInfo.setError(QString("Can't cast to sequence from: %1").arg(obj->getGObjectName()));
            return;
        }    

        seqList.append(mySequence);
    }
    
    ImportQualityScoresConfig cfg;
    cfg.createNewDocument = false;
    cfg.fileName = fileName;
    cfg.type = DNAQualityType_Sanger;

    Task* importTask = new ImportPhredQualityScoresTask(seqList, cfg);

    addSubTask(importTask);

}


QList<XMLTestFactory*> DNAExportPluginTests::createTestFactories()
{
    QList<XMLTestFactory*> factories;
    factories.append(GTest_ImportPhredQualityScoresTask::createFactory());

    return factories;
}


} //namespace
