/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <cassert>

#include "DirectSocketUtils.h"

namespace GB2 {

bool DirectSocketUtils::writeToSocket( QTcpSocket & socket, const QVariant & data ) {
    QByteArray dataBuf;
    QDataStream dataBufStream( &dataBuf, QIODevice::WriteOnly );
    dataBufStream << data;
    QByteArray buf;
    QDataStream( &buf, QIODevice::WriteOnly ) << dataBuf.size();
    buf.append( dataBuf );
    
    qint64 howMany = socket.write( buf );
    if( buf.size() != howMany || !socket.waitForBytesWritten() ) {
        return false;
    }
    return true;
}

bool DirectSocketUtils::readFromSocket( QTcpSocket & socket, QVariant * to ) {
    if( NULL == to ) {
        return false;
    }
    if( !socket.waitForReadyRead() ) {
        return false;
    }
    
    int sz = 0;
    QDataStream( &socket ) >> sz;
    qint64 bytesRead = 0;
    QByteArray bytes;
    while( bytesRead != sz ) {
        qint64 available = socket.bytesAvailable();
        if( !available ) {
            if( !socket.waitForReadyRead() ) {
                return false;
            }
            available = socket.bytesAvailable();
            assert( 0 < available );
        }
        QByteArray tt( available, 0 );
        qint64 ret = socket.read( tt.data(), available );
        if( -1 == ret || 0 == ret ) {
            return false;
        }
        bytesRead += ret;
        bytes.append( tt.data(), ret );
    }
    
    QDataStream bytesStream( &bytes, QIODevice::ReadOnly );
    bytesStream >> *to;
    return true;
}

} // GB2
