/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_SETTINGS_H_
#define _GB2_SMITH_WATERMAN_SETTINGS_H_

#include <core_api/LRegion.h>
#include <core_api/DNATranslation.h>

#include <datatype/SMatrix.h>
#include <util_smith_waterman/SmithWatermanReportCallback.h>
#include <util_smith_waterman/SmithWatermanResultFilters.h>
#include <util_smith_waterman/SmithWatermanResult.h>
#include <util_smith_waterman/SmithWatermanResult.h>
#include <util_tasks/SequenceWalkerTask.h>

namespace GB2 {

static inline bool isComplement(StrandOption strand) {
    return StrandOption_Both== strand || StrandOption_ComplementOnly == strand;
}
static inline bool isDirect(StrandOption strand) {
        return StrandOption_Both== strand || StrandOption_DirectOnly == strand;
}

struct GapModel {		
	float scoreGapOpen;
	float scoreGapExtd;
};

struct SmithWatermanSettings {
    SmithWatermanSettings() 
        : percentOfScore(0), complTT( NULL ), aminoTT( NULL ),
        resultListener( NULL ), resultFilter( NULL ),
        resultCallback( NULL ) {
    }

    QByteArray          ptrn;
	QByteArray          sqnc;

	LRegion	            globalRegion;
        StrandOption strand;

    float               percentOfScore;	
	GapModel            gapModel;
	SMatrix             pSm;	    

    DNATranslation*     complTT;
    DNATranslation*     aminoTT;
	
	SmithWatermanResultListener* resultListener;
    SmithWatermanResultFilter*   resultFilter;
    SmithWatermanReportCallback* resultCallback;

    bool operator==(const SmithWatermanSettings& op) const {
        return  ptrn == op.ptrn && 
                sqnc == op.sqnc && 
                globalRegion == op.globalRegion && 
                strand == op.strand &&
                gapModel.scoreGapExtd == op.gapModel.scoreGapExtd &&
                gapModel.scoreGapOpen == op.gapModel.scoreGapOpen;    
    }
};

} // namespace

#endif
