/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHICS_RECTANGULAR_BRANCH_ITEM_H_
#define _GB2_GRAPHICS_RECTANGULAR_BRANCH_ITEM_H_

#include <core_api/Task.h>
#include "GraphicsBranchItem.h"

namespace GB2 {

class PhyNode;
class GraphicsButtonItem;

class GraphicsRectangularBranchItem: public GraphicsBranchItem {
public:
    static const qreal DEFAULT_WIDTH;
    static const qreal MAXIMUM_WIDTH;
    static const int DEFAULT_HEIGHT;

private:
    qreal height;
    Direction direction;

public:
    GraphicsRectangularBranchItem();
    GraphicsRectangularBranchItem(const QString& name, GraphicsRectangularBranchItem* pitem);
    GraphicsRectangularBranchItem(qreal d);
    GraphicsRectangularBranchItem(qreal x, qreal y, const QString& name, qreal d);
    GraphicsRectangularBranchItem(qreal x, qreal y, const QString& name);

    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
    QPainterPath shape() const;
    void setParentItem(QGraphicsItem *item);

    Direction getDirection() const { return direction; }
    qreal getHeight() const { return height; }
    void setHeightW(qreal h) { height = h; }
    void setHeight(qreal h);
    void setDirection(Direction d);

    void collapse();
};

}//namespace;

#endif
