/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EDIT_ALIGNMENT_TESTS_H_
#define _GB2_EDIT_ALIGNMENT_TESTS_H_

#include <datatype/MAlignment.h>
#include <core_api/GUrl.h>

#include <test_framework/GTest.h>
#include <test_framework/xmltest/XMLTestUtils.h>

#include <QtXml/QDomElement>

#include "CreateSubalignimentTask.h"

namespace GB2 {

class DNASequenceObject;

class GTest_CreateSubalignimentTask : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_CreateSubalignimentTask, "plugin_create-subaligniment-task", TaskFlags_NR_FOSCOE);
    void prepare();
    Task::ReportResult report();   

private:
	MAlignmentObject *maobj;
	MAlignmentObject *expectedMaobj;
	QString docName;
	bool negativeTest;
	Task *t;
	QString expectedDocName;
	QStringList seqNames;
	LRegion window;
};

class GTest_RemoveAlignmentRegion : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_RemoveAlignmentRegion, "test-remove-alignment-region", TaskFlags_NR_FOSCOE);
    void prepare();
    Task::ReportResult report();   

private:
    MAlignmentObject *maobj;
    MAlignmentObject *expectedMaobj;
    QString docName;
    QString expectedDocName;
    int startBase, startSeq, width, height;
};


class GTest_AddSequenceToAlignment : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_AddSequenceToAlignment, "test-add-seq-to-alignment", TaskFlags_NR_FOSCOE);
    void prepare();
    Task::ReportResult report();   

private:
    MAlignmentObject *maobj;
    MAlignmentObject *expectedMaobj;
    QString docName;
    QString expectedDocName;
    QString seqFileName;
};

class CreateSubalignimentTests {
public:
	static QList< XMLTestFactory* > createTestFactories();
};


}

#endif //_GB2_EDIT_ALIGNMENT_TESTS_H_
