/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CREATE_SUBALIGNIMENT_TASK_H_
#define _GB2_CREATE_SUBALIGNIMENT_TASK_H_

#include <core_api/Task.h>
#include <core_api/GUrl.h>
#include <core_api/LRegion.h>
#include <gobjects/MAlignmentObject.h>



namespace GB2{

class CreateSubalignimentTask : public Task {
	Q_OBJECT
public:    
    CreateSubalignimentTask(MAlignmentObject* _maObj, LRegion _window, 
							const QStringList& _seqNames, const GUrl& _url, 
							bool _addToProject = false, bool saveImmediately = false );

    ~CreateSubalignimentTask(){};

	void prepare();
    Task::ReportResult report();

private:
    bool		saveToAnother;
    Document *	curDoc;
    MAlignmentObject* maObj;
    LRegion		window;
    QStringList seqNames;
    GUrl		url;
    bool		addToProject;
	Document*	newDoc;
    bool		saveImmediately;
};

}

#endif
