/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_CONSENSUS_ALGORITHM_REGISTRY_H_
#define _GB2_MSA_CONSENSUS_ALGORITHM_REGISTRY_H_

#include "MSAConsensusAlgorithm.h"

#include <QtCore/QStringList>

namespace GB2 {

class MSAConsensusAlgorithm;

class GB2_COREAPI_EXPORT MSAConsensusAlgorithmRegistry : public QObject {
	Q_OBJECT

public:
	MSAConsensusAlgorithmRegistry(QObject* p = NULL);

    ~MSAConsensusAlgorithmRegistry();

	MSAConsensusAlgorithmFactory* getAlgorithmFactory(const QString& algoId);

	void addAlgorithm(MSAConsensusAlgorithmFactory* algo);

	QStringList getAlgorithmIds() const ;

	QList<MSAConsensusAlgorithmFactory*> getAlgorithmFactories() const {return algorithms.values();}

    QList<MSAConsensusAlgorithmFactory*> getAlgorithmFactories(ConsensusAlgorithmFlags flags) const;

private:
	QMap<QString , MSAConsensusAlgorithmFactory*> algorithms;
};

}//namespace

#endif
