/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_PATH_TO_SEQUENCE_TESTS_H_
#define _GB2_ADD_PATH_TO_SEQUENCE_TESTS_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>
#include <core_api/GObject.h>

#include <util_tasks/AddPartToSequenceTask.h>

#include <gobjects/DNASequenceObject.h>

#include <test_framework/xmltest/XMLTestUtils.h>

#include <QtXml/QDomElement>

namespace GB2 {

class GTest_AddPartToSequenceTask : GTest {
Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_AddPartToSequenceTask, "Add_Part_To_Sequence_Task", TaskFlags_NR_FOSCOE);

    ~GTest_AddPartToSequenceTask();
    void prepare();
    Task::ReportResult report();
private:
    AddPartToSequenceTask::AnnotationStrategyForAdd strat;
    QString             docName;
    QString             seqName;
    int                 startPos;
    QString             insertedSequence;
    QString             annotationName;
    QString             expectedSequence;
    QList<LRegion>      expectedRegions;
    DNASequenceObject*  dnaso;
};
class AddPartToSequenceTests {
public:
    static QList< XMLTestFactory* > createTestFactories();

};
}//ns
#endif
