/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SELECTION_UTILS_H_
#define _GB2_SELECTION_UTILS_H_

#include <core_api/LRegion.h>
#include <QtCore/QSet>

namespace GB2 {

class GObject;
class Document;
class MultiGSelection;
class GSelection;

class GB2_COREAPI_EXPORT SelectionUtils {
public:
	
	static QSet<GObject*>	findObjects(GObjectType t, const MultiGSelection* s, UnloadedObjectFilter f);

    static QList<GObject*>	findObjectsKeepOrder(GObjectType t, const MultiGSelection* s, UnloadedObjectFilter f);
	
	static QSet<GObject*>	findObjects(GObjectType t, const GSelection* s, UnloadedObjectFilter f);

    static QList<GObject*>	findObjectsKeepOrder(GObjectType t, const GSelection* s, UnloadedObjectFilter f);
	
	static QSet<Document*>	findDocumentsWithObjects(GObjectType t, const MultiGSelection* s, 
                        		UnloadedObjectFilter f, bool deriveDocsFromObjectSelection);
	
	static QSet<Document*>	findDocumentsWithObjects(GObjectType t, const GSelection* s, 
		                        UnloadedObjectFilter f, bool deriveDocsFromObjectSelection);

	static bool isDocumentInSelection(const Document* doc, const MultiGSelection& ms, bool deriveDocsFromObjectSelection);

	static QList<Document*> getSelectedDocs(const MultiGSelection& ms);

	static QList<GObject*> getSelectedObjects(const MultiGSelection& ms);

    //todo: find a better place: like DNAUtils..
    static LRegion normalizeRegionBy3(LRegion reg, int seqLen, bool direct);
};




}//namespace

#endif

