/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include  <phyltree/PhyTreeGeneratorRegistry.h>

namespace GB2 {

	PhyTreeGeneratorRegistry::PhyTreeGeneratorRegistry( QObject* pOwn /*= 0*/ ) : QObject(pOwn)
	{}

	PhyTreeGeneratorRegistry::~PhyTreeGeneratorRegistry()
	{
		foreach( PhyTreeGenerator* generator, genMap.values()) {
			delete generator;
		}
	}

	bool PhyTreeGeneratorRegistry::registerPhyTreeGenerator( PhyTreeGenerator* generator , const QString& gen_id)
	{
		if (genMap.contains(gen_id)){
			return false;
		}
		genMap.insert(gen_id, generator);
		return true;

	}

	bool PhyTreeGeneratorRegistry::hadRegistered( const QString& gen_id)
	{
		return genMap.contains(gen_id);
	}

	PhyTreeGenerator* PhyTreeGeneratorRegistry::getGenerator(const QString& gen_id)
	{
		if (genMap.contains(gen_id)) {
			return genMap.value(gen_id);
		} else {
			return NULL;
		}
	}

	QStringList PhyTreeGeneratorRegistry::getNameList()
	{
		return genMap.keys();
	}

} // namespace GB2
