/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _SAM_FORMAT_H
#define _SAM_FORMAT_H

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;

class GB2_COREAPI_EXPORT  SAMFormat : public DocumentFormat {
	Q_OBJECT
public:
	SAMFormat(QObject* p);

	virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::SAM;}

	virtual const QString& getFormatName() const {return formatName;}

	virtual Document* loadDocument( IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);

	virtual void storeDocument( Document* d, TaskStateInfo& ts, IOAdapter* io );

	virtual bool checkRawData(const QByteArray& rawData) const;

	struct Field {
		Field(QString _name, QByteArray _val, QRegExp _pattern): name(_name), val(_val), pattern(_pattern) {}
		QString name;
		QByteArray val;
		QRegExp pattern;
	};

private:

	static bool getSectionTags(QByteArray &line, const QByteArray &sectionName, QList<QByteArray> &tags);

	static const QByteArray VERSION; 

 	static const QByteArray SAM_SECTION_START;
 
 	static const QByteArray SECTION_HEADER; //Header
 	static const QByteArray SECTION_SEQUENCE; //Sequence dictionary
	static const QByteArray SECTION_READ_GROUP; //read group
	static const QByteArray SECTION_PROGRAM; //Program
	static const QByteArray SECTION_COMMENT; //comment

	static const QByteArray TAG_VERSION; //File format version.
	static const QByteArray TAG_SORT_ORDER; //Sort order. Valid values are: unsorted, queryname or coordinate.
	static const QByteArray TAG_GROUP_ORDER; //Group order (full sorting is not imposed in a group). Valid values are: none, query or reference.

	static const QByteArray TAG_SEQUENCE_NAME; //Sequence name. Unique among all sequence records in the file. The value of this field is used in alignment records.
	static const QByteArray TAG_SEQUENCE_LENGTH; //Sequence length.
	static const QByteArray TAG_GENOME_ASSEMBLY_ID; //Genome assembly identifier. Refers to the reference genome assembly in an unambiguous	form. Example: HG18.
	static const QByteArray TAG_SEQUENCE_MD5_SUM; //MD5 checksum of the sequence in the uppercase (gaps and space are removed)
	static const QByteArray TAG_SEQUENCE_URI; //URI of the sequence
	static const QByteArray TAG_SEQUENCE_SPECIES; //Species.

	/*
	static const TAG_READ_GROUP_ID = "ID";
	static const TAG_READ_GROUP_SAMPLE = "SM";
	static const TAG_READ_GROUP_LIBRARY = "LB";
	static const TAG_READ_GROUP_DESCRIPTION = "DS";
	static const TAG_READ_GROUP_PLATFORM = "PU";
	*/

	QString formatName;
};

} //namespace

#endif //_SAM_FORMAT_H