/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_PROTOCOL_INFO_H_
#define _GB2_PROTOCOL_INFO_H_

#include <core_api/core_api.h>
#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QMap>

namespace GB2 {

class RemoteTaskServer;
class ProtocolUI;
class RemoteMachineFactory;
class RemoteMachineScanner;

class GB2_COREAPI_EXPORT ProtocolInfo {
public:
    ProtocolInfo( const QString &id, RemoteTaskServer *server, ProtocolUI *protocolUI,
        RemoteMachineFactory *remoteMachineFactory, RemoteMachineScanner *scanner );
    
    RemoteTaskServer *getRemoteTaskServer() const;
    ProtocolUI *getProtocolUI() const;
    RemoteMachineFactory *getRemoteMachineFactory() const;
    RemoteMachineScanner *getRemoteMachineScanner() const;
    
    // TODO: do we need version?
    QString getId() const;

private:
    RemoteTaskServer *server;
    ProtocolUI *protocolUI;
    RemoteMachineFactory *remoteMachineFactory;
    RemoteMachineScanner *scanner;
    
    QString id;

}; // ProtocolInfo

class GB2_COREAPI_EXPORT ProtocolInfoRegistry {
public:
    void registerProtocolInfo( ProtocolInfo *info );
    bool unregisterProtocolInfo( const QString &id );
    bool isProtocolInfoRegistered( const QString &id ) const;
    ProtocolInfo *getProtocolInfo( const QString &id ) const;
    QList< ProtocolInfo * > getProtocolInfos() const;

private:
    QMap< QString, ProtocolInfo * > protocolInfos;

}; // ProtcolInfoRegistry

} // GB2

#endif // _GB2_PROTOCOL_INFO_H_
