/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_DISTRIBUTED_COMPUTING_UTIL_H
#define _GB2_DISTRIBUTED_COMPUTING_UTIL_H

#include <QtCore/QObject>

#include <util_tasks/PingTask.h>
#include <util_smith_waterman/SmithWatermanLocalTask.h>
#include <util_gui/RemoteMachineMonitorDialogImpl.h>

#include <distributed_computing/LocalTask.h>
#include <distributed_computing/LocalTaskManager.h>
#include <distributed_computing/ProtocolInfo.h>
#include <distributed_computing/RemoteMachineMonitor.h>

namespace GB2 {

class GB2_COREAPI_EXPORT DistributedComputingUtil : public QObject {
    Q_OBJECT
public:
    DistributedComputingUtil();
    ~DistributedComputingUtil();
    
    /* following functions help to work with RemoteMachinesMonitorDialog */
    /* if not to call this function after exec of RemoteMachineMonitorDialog -> you should delete new machines by yourself */
    static void applyChangesForRemoteMachineMonitor( RemoteMachineMonitor * rmm, 
        const QList< RemoteMachineMonitorDialogItem > & model );
    
    /* remote machines has some services that are only for internal usage. this function filters them */
    static QStringList filterRemoteMachineServices( const QStringList & services );
    
private slots:
    void sl_showRemoteMachinesMonitor();
    
private:
    /* pointers here to manage object creation order */
    LocalTaskFactoryRegistry *    ltfr;
    LocalTaskManager *            ltm;
    ProtocolInfoRegistry *        pir;
    RemoteMachineMonitor *        rmm;
    
    // core LocalTasks
    PingTaskFactory                 pingFactory;
    SmithWatermanLocalTaskFactory   swFactory;
    
}; // DistributedComputingUtil

/* RemoteMachine functions are blocking, so this task can be useful, 
 * because it waits for remote machine responses in separate thread 
 */
class RetrieveRemoteMachineInfoTask : public Task {
    Q_OBJECT
public:
    RetrieveRemoteMachineInfoTask( RemoteMachine * m );
    ~RetrieveRemoteMachineInfoTask();
    
    virtual void run();
    virtual ReportResult report();
    
    QStringList getServicesList() const;
    QUuid getUuid() const;
    QString getHostName() const;
    bool isPinging() const;
    /* if machine was not taken back from this task -> it will be deleted in destructor of this task */
    RemoteMachine * takeMachine();
    
private:
    QStringList             services;
    QUuid                   uuid;
    QString                 hostname;
    
    bool                    doPing;
    RemoteTask *            pingTask;
    RemoteMachine *         machine;
    
}; // RetrieveRemoteMachineInfoTask


/* Retrieves public RemoteMachines settings from hard-coded ugene websites
 */
class RetrievePublicMachinesTask : public Task {
    Q_OBJECT
public:
    static const QString PUBLIC_MACHINES_KEEPER_SERVER;
    static const QString PUBLIC_MACHINES_KEEPER_PAGE;
    static const QString PUBLIC_MACHINES_STR_SEPARATOR;
    
public:
    RetrievePublicMachinesTask();
    ~RetrievePublicMachinesTask();
    
    virtual void run();
    
    QList< RemoteMachineSettings* > getPublicMachines() const;
    QList< RemoteMachineSettings* > takePublicMachines();
    
private:
    void processEncodedMachines( const QString & encodedMachines );
    
private:
    QList< RemoteMachineSettings* > publicMachines;
    
}; // RetrievePublicMachinesTask

class SaveRemoteMachineSettings : public Task {
    Q_OBJECT
public:
    SaveRemoteMachineSettings(RemoteMachineSettings * machineSettings, const QString& filename);
    virtual void run();
    
private:
    QByteArray data;
    QString filename;
    
}; // SaveRemoteMachineSettings

} // GB2

#endif // _GB2_DISTRIBUTED_COMPUTING_UTIL_H
