/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_api/AppContext.h>
#include <test_framework/GTestFrameworkComponents.h>
#include <test_framework/xmltest/XMLTestFormat.h>
#include <util_algorithm/GAutoDeleteList.h>

#include "CMDLineUtils.h"
#include "CMDLineCoreOptions.h"
#include "CMDLineTests.h"

namespace GB2 {

/***************************************************
* CMDLineRegistryUtils
***************************************************/
int CMDLineRegistryUtils::getParameterIndex( const QString & paramName, int startWith ) {
    QList<StringPair> params;
    setCMDLineParams( params );
    int sz = params.size();
    for( int i = qMax( 0, startWith ); i < sz; ++i ) {
        if( params[i].first == paramName ) {
            return i;
        }
    }
    return -1;
}

QStringList CMDLineRegistryUtils::getParameterValues( const QString & paramName, int startWith ) {
    QList<StringPair> params;
    setCMDLineParams( params );
    QStringList res;
    int sz = params.size();
    int paramIdx = getParameterIndex( paramName, startWith );
    if( -1 == paramIdx ) { // no such parameter
        return res;
    }
    for( int i = paramIdx; i < sz; ++i ) {
        res << params[i].second;
        if( i + 1 < sz && !params[i + 1].first.isEmpty() ) {
            break;
        }
    }
    return res;
}

QStringList CMDLineRegistryUtils::getParameterValuesByWords( const QString & paramName, int startWith ) {
    QStringList words;
    QStringList res = getParameterValues( paramName, startWith );
    QStringList::const_iterator it = res.constBegin();
    while( it != res.constEnd() ) {
        words << it->split( QRegExp("\\s"), QString::SkipEmptyParts );
        ++it;
    }
    return words;
}

QStringList CMDLineRegistryUtils::getPureValues( int startWithIdx ) {
    QList<StringPair> params;
    setCMDLineParams( params );
    QStringList res;
    int sz = params.size();
    for( int i = qMax( 0, startWithIdx ); i < sz; ++i ) {
        const StringPair & currentPair = params[i];
        if( currentPair.first.isEmpty() ) {
            res << currentPair.second;
        } else {
            break;
        }
    }
    return res;
}

void CMDLineRegistryUtils::setCMDLineParams( QList<StringPair> & to ) {
    CMDLineRegistry * cmdlineRegistry = AppContext::getCMDLineRegistry();
    if( cmdlineRegistry != NULL ) {
        to = cmdlineRegistry->getParameters();
    }
}

/***************************************************
* CMDLineUtils
***************************************************/
void CMDLineUtils::init() {
    CMDLineCoreOptions::initHelp();
    
    // register test factories
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);
    
    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(NULL);
    l->qlist = CMDLineTests::createTestFactories();
    
    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        assert(res);
        Q_UNUSED(res);
    }
}

} // GB2
