/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CheckUpdatesTask.h"
#include <core_api/AppGlobals.h>

#include <core_api/AppContext.h>
#include <core_api/AppSettings.h>
#include <core_api/NetworkConfiguration.h>
#include <core_api/MainWindow.h>
#include <util_gui/GUIUtils.h>
#include <util_algorithm/SynchHttp.h>

#include <QtGui/QMessageBox>
#include <QtGui/QPushButton>

namespace GB2 {

CheckUpdatesTask::CheckUpdatesTask() 
:Task(tr("Check for updates"), TaskFlag_None)
{
    setVerboseLogMode(true);
}

#define SITE_URL  QString("ugene.unipro.ru")
#define PAGE_NAME QString("/current_version.html")

void CheckUpdatesTask::run() {
    stateInfo.setStateDesc(tr("Connecting to updates server"));
    NetworkConfiguration* nc = AppContext::getAppSettings()->getNetworkConfiguration();
    bool isProxy = nc->isProxyUsed(QNetworkProxy::HttpProxy);
    bool isException = nc->getExceptionsList().contains(SITE_URL);
    SyncHTTP http(SITE_URL);
    if (isProxy && !isException) {
        http.setProxy(nc->getProxy(QNetworkProxy::HttpProxy));
    }
    siteVersion = http.syncGet(PAGE_NAME);
    stateInfo.setStateDesc(QString());

    if (http.error() != QHttp::NoError) {
        stateInfo.setError(  tr("Connection error: %1").arg(http.errorString()) );
        return;
    }
}

Task::ReportResult CheckUpdatesTask::report() {
    if (hasErrors()) {
        return ReportResult_Finished;
    }
    QString thisVersion = QString("%1.%2.%3").arg(UGENE_VERSION_1).arg(UGENE_VERSION_2).arg(UGENE_VERSION_3);
    QString message = "<table><tr><td>"+tr("Your version:") + "</td><td><b>"+thisVersion+"</b></td></tr>";
    message+="<tr><td>" + tr("Latest version:") + "</td><td><b>"+siteVersion+"</b></td></tr></table>";
    bool needUpdate = thisVersion != siteVersion;
    if (!needUpdate) {
        message += "<p>" + tr("You have the latest  version");
    }
    
    QWidget *p = (QWidget*)(AppContext::getMainWindow()->getQMainWindow());
    QMessageBox box(QMessageBox::Information, tr("Version information"), message, QMessageBox::NoButton, p);
    box.addButton(QMessageBox::Ok);
    QAbstractButton* updateButton = NULL;
    
    if (needUpdate) {
        updateButton = box.addButton(tr("Visit web site"), QMessageBox::ActionRole);
    }
    box.exec();

    if (box.clickedButton() == updateButton) {
        GUIUtils::runWebBrowser("http://ugene.unipro.ru/download.html");
    }
    return ReportResult_Finished;    
}


} //namespace
