/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "seqdb.h"
#include "Muscle4Context.h"
#include "Muscle4TaskLocalStorage.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

void FwdBwd(SeqDB &DB, unsigned IdA, unsigned IdB, SparseMx &SPP);
void FwdBwdLocal(SeqDB &DB, unsigned IdA, unsigned IdB, SparseMx &SPP);

void SeqDB::ComputeSPPs(bool Local)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	if (!m_SPPs.empty())
		return;

	const unsigned SeqCount = GetSeqCount();
	const unsigned PairCount = GetPairCount();
	m_SPPs.resize(PairCount);
	for (unsigned i = 0; i < PairCount; ++i)
		{
		m_SPPs[i] = new SparseMx;
		if (m_SPPs[i] == 0)
			Die("Out of memory");
		}

	unsigned Counter = 0;
	for (unsigned SeqIndex1 = 0; SeqIndex1 < SeqCount; ++SeqIndex1)
		{
		stopIfCanceled(*(ctx->info));
		const string &Label1 = GetLabel(SeqIndex1);

		for (unsigned SeqIndex2 = SeqIndex1 + 1; SeqIndex2 < SeqCount; ++SeqIndex2)
			{
			stopIfCanceled(*(ctx->info));
			const string &Label2 = GetLabel(SeqIndex2);

			unsigned PairIndex = GetPairIndex(SeqIndex1, SeqIndex2);
			ctx->info->setStateDesc(tr("Aligning pairs %1 and %2").arg(Label1.c_str()).arg(Label1.c_str()));
			//ProgressStep(Counter++, PairCount, cs, Label1.c_str(), Label2.c_str());
			SparseMx &SPP = *m_SPPs[PairIndex];
			if (Local)
				FwdBwdLocal(*this, SeqIndex1, SeqIndex2, SPP);
			else
				FwdBwd(*this, SeqIndex1, SeqIndex2, SPP);

			if (ctx->opt_trace)
				SPP.LogMe();
			}
		}
	}

void ComputeSelfSPPs(vector<SparseMx *> &SPPs)
	{
	asserta(SPPs.empty());
	}
