/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "params.h"
#include "mx.h"
#include "seqdb.h"
#include <set>
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>
//#include "muscletypes.h"

void ReadSubstMx(const char *FileName, Mx<float> &Mxf);

static void AlgoFwdBwd(const string &Algo, const string &FwdBwdName, FWD_BWD FwdBwd);
static void AlgoTrans(const string &Algo, const string &Trans, float *Address);
static void ModelAlgo(const string &Model, const string &Algo);
static void ModelOptTrans(const string &Model, const string &Opt, const string &Trans);
static void ModelOptDefaultHelp(const string &Model, const string &Opt, float Default, const string &Help);
static void Opt(const string &Name, double *Address);

#define C(x)	float FwdBwd##x(Mx<float> &PPf); AlgoFwdBwd(#x, "FwdBwd" #x, FwdBwd##x);

#define A(x, y)			AlgoTrans(#x, #y, &Trans##y);
#define M(x, y)			ModelAlgo(#x, #y);
#define P(x, y, z)		ModelOptTrans(#x, #y, #z);
#define D(w, x, y, z)	ModelOptDefaultHelp(#w, #x, float(y), #x);
#define	Q(x)			Opt(#x, &opt_##x);

//static string g_Model;

const string &GetModel(){
	GB2::Muscle4Context *ctx = getMuscle4Context();
	return ctx->g_Model;
}

void InitModelData()
	{
		//float FwdBwdSWCRF(Mx<float> &PPf); 
		//AlgoFwdBwd("SWCRF", "FwdBwdSWCRF", FwdBwdSWCRF);
		//float FwdBwdFull(Mx<float> &PPf); 
		//AlgoFwdBwd("FULL", "FwdBwdFull", FwdBwdFull);
	//static bool InitDone = false;
	//if (InitDone)
	//s	return;
	GB2::Muscle4Context *ctx = getMuscle4Context();

	AlgoTrans("SWCRF", "MD", &(ctx->TransMD));
	AlgoTrans("SWCRF", "MI", &(ctx->TransMI));
	AlgoTrans("SWCRF", "DD", &(ctx->TransDD));
	AlgoTrans("SWCRF", "II", &(ctx->TransII));

	AlgoTrans("PCCRF", "DD", &(ctx->TransDD));
	AlgoTrans("PCCRF", "DE", &(ctx->TransDE));
	AlgoTrans("PCCRF", "DE", &(ctx->TransDE));
	AlgoTrans("PCCRF", "II", &(ctx->TransII));
	AlgoTrans("PCCRF", "MD", &(ctx->TransMD));
	AlgoTrans("PCCRF", "ME", &(ctx->TransME));
	AlgoTrans("PCCRF", "MI", &(ctx->TransMI));
	AlgoTrans("PCCRF", "MX", &(ctx->TransMX));
	AlgoTrans("PCCRF", "MY", &(ctx->TransMY));
	AlgoTrans("PCCRF", "SD", &(ctx->TransSD));
	AlgoTrans("PCCRF", "SI", &(ctx->TransSI));
	AlgoTrans("PCCRF", "SX", &(ctx->TransSX));
	AlgoTrans("PCCRF", "SY", &(ctx->TransSY));
	AlgoTrans("PCCRF", "XE", &(ctx->TransXE));
	AlgoTrans("PCCRF", "XX", &(ctx->TransXX));
	AlgoTrans("PCCRF", "YE", &(ctx->TransYE));
	AlgoTrans("PCCRF", "YY", &(ctx->TransYY));

	AlgoTrans("PCHMM", "DD", &(ctx->TransDD));
	AlgoTrans("PCHMM", "DE", &(ctx->TransDE));
	AlgoTrans("PCHMM", "DM", &(ctx->TransDM));
	AlgoTrans("PCHMM", "IE", &(ctx->TransIE));
	AlgoTrans("PCHMM", "II", &(ctx->TransII));
	AlgoTrans("PCHMM", "IM", &(ctx->TransIM));
	AlgoTrans("PCHMM", "MD", &(ctx->TransMD));
	AlgoTrans("PCHMM", "ME", &(ctx->TransME));
	AlgoTrans("PCHMM", "MI", &(ctx->TransMI));
	AlgoTrans("PCHMM", "MM", &(ctx->TransMM));
	AlgoTrans("PCHMM", "MX", &(ctx->TransMX));
	AlgoTrans("PCHMM", "MY", &(ctx->TransMY));
	AlgoTrans("PCHMM", "SD", &(ctx->TransSD));
	AlgoTrans("PCHMM", "SI", &(ctx->TransSI));
	AlgoTrans("PCHMM", "SM", &(ctx->TransSM));
	AlgoTrans("PCHMM", "SX", &(ctx->TransSX));
	AlgoTrans("PCHMM", "SY", &(ctx->TransSY));
	AlgoTrans("PCHMM", "XE", &(ctx->TransXE));
	AlgoTrans("PCHMM", "XM", &(ctx->TransXM));
	AlgoTrans("PCHMM", "XX", &(ctx->TransXX));
	AlgoTrans("PCHMM", "YE", &(ctx->TransYE));
	AlgoTrans("PCHMM", "YM", &(ctx->TransYM));
	AlgoTrans("PCHMM", "YY", &(ctx->TransYY));

AlgoTrans("Full", "SD", &(ctx->TransSD));
AlgoTrans("Full", "SI", &(ctx->TransSI));
AlgoTrans("Full", "SX", &(ctx->TransSX));
AlgoTrans("Full", "SY", &(ctx->TransSY));
AlgoTrans("Full", "MD", &(ctx->TransMD));
AlgoTrans("Full", "MI", &(ctx->TransMI));
AlgoTrans("Full", "MX", &(ctx->TransMX));
AlgoTrans("Full", "MY", &(ctx->TransMY));
AlgoTrans("Full", "DD", &(ctx->TransDD));
AlgoTrans("Full", "II", &(ctx->TransII));
AlgoTrans("Full", "XX", &(ctx->TransXX));
AlgoTrans("Full", "YY", &(ctx->TransYY));
AlgoTrans("Full", "LDD", &(ctx->TransLDD));
AlgoTrans("Full", "LII", &(ctx->TransLII));
AlgoTrans("Full", "LXX", &(ctx->TransLXX));
AlgoTrans("Full", "LYY", &(ctx->TransLYY));
AlgoTrans("Full", "RDD", &(ctx->TransRDD));
AlgoTrans("Full", "RII", &(ctx->TransRII));
AlgoTrans("Full", "RMD", &(ctx->TransRMD));
AlgoTrans("Full", "RMI", &(ctx->TransRMI));
AlgoTrans("Full", "RMX", &(ctx->TransRMX));
AlgoTrans("Full", "RMY", &(ctx->TransRMY));
AlgoTrans("Full", "RXX", &(ctx->TransRXX));
AlgoTrans("Full", "RYY", &(ctx->TransRYY));

	




	#include "models.h"

	


	//InitDone = true;
	
	}

/*struct AlgoFwdBwdData
	{
	string Algo;
	string FwdBwdName;
	FWD_BWD FwdBwd;
	};

struct AlgoTransData
	{
	string Algo;
	string Trans;
	float *Address;
	};

struct ModelAlgoData
	{
	string Model;
	string Algo;
	};

struct ModelOptTransData
	{
	string Model;
	string Opt;
	string Trans;
	};

struct ModelOptDefaultHelpData
	{
	string Model;
	string Opt;
	float Default;
	string Help;
	};

struct OptData
	{
	string Name;
	double *Address;
	};*/

//static vector<AlgoFwdBwdData> g_AlgoFwdBwd;
//static vector<AlgoTransData> g_AlgoTrans;
//static vector<ModelAlgoData> g_ModelAlgo;
//static vector<ModelOptTransData> g_ModelOptTrans;
//static vector<ModelOptDefaultHelpData> g_ModelOptDefaultHelp;
//static vector<OptData> g_Opt;
//static set<string> g_Algos;

static void AlgoFwdBwd(const string &Algo, const string &FwdBwdName, FWD_BWD FwdBwd)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	AlgoFwdBwdData D;
	D.Algo = Algo;
	D.FwdBwd = FwdBwd;
	D.FwdBwdName = FwdBwdName;
	ctx->g_AlgoFwdBwd.push_back(D);
	}

static void AlgoTrans(const string &Algo, const string &Trans, float *Address)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	AlgoTransData D;
	D.Algo = Algo;
	D.Trans = Trans;
	D.Address = Address;
	ctx->g_AlgoTrans.push_back(D);

	if (ctx->g_Algos.find(Algo) == ctx->g_Algos.end())
		ctx->g_Algos.insert(Algo);
	}

static void ModelAlgo(const string &Model, const string &Algo)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	ModelAlgoData D;
	D.Model = Model;
	D.Algo = Algo;
	ctx->g_ModelAlgo.push_back(D);
	}

static void ModelOptTrans(const string &Model, const string &Opt, const string &Trans)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	ModelOptTransData D;
	D.Model = Model;
	D.Opt = Opt;
	D.Trans = Trans;
	ctx->g_ModelOptTrans.push_back(D);
	}

static void ModelOptDefaultHelp(const string &Model, const string &Opt, float Default,
  const string &Help)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	ModelOptDefaultHelpData D;
	D.Model = Model;
	D.Opt = Opt;
	D.Default = Default;
	D.Help = Help;
	ctx->g_ModelOptDefaultHelp.push_back(D);
	}

static void Opt(const string &Name, double *Address)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	OptData D;
	D.Name = Name;
	D.Address = Address;
	ctx->g_Opt.push_back(D);
	}

static const ModelOptTransData *GetModelTransOpt(const string &Model,
  const string &Trans)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	for (unsigned i = 0; i < SIZE(ctx->g_ModelOptTrans); ++i)
		{
		const ModelOptTransData &MOT = ctx->g_ModelOptTrans[i];
		if (MOT.Model == Model && MOT.Trans == Trans)
			return &MOT;
		}
	return 0;
	}

static FWD_BWD GetFwdBwd(const string &Algo)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	for (unsigned i = 0; i < SIZE(ctx->g_AlgoFwdBwd); ++i)
		{
		const AlgoFwdBwdData &D = ctx->g_AlgoFwdBwd[i];
		if (D.Algo == Algo)
			return D.FwdBwd;
		}
	Die("GetFwdBwd(%s), not found", Algo.c_str());
	ureturn(0);
	}

static float GetOptValue(const string &Name)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	for (unsigned i = 0; i < SIZE(ctx->g_Opt); ++i)
		{
		const OptData &OD = ctx->g_Opt[i];
		if (OD.Name == Name)
			return *OD.Address;
		}
	Die("GetOptValue(%s), not found", Name.c_str());
	ureturn(0);
	}

static float GetDefaultOptValue(const string &Model, const string &Opt)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	for (unsigned i = 0; i < SIZE(ctx->g_ModelOptDefaultHelp); ++i)
		{
		const ModelOptDefaultHelpData &D = ctx->g_ModelOptDefaultHelp[i];
		if (D.Model == Model && D.Opt == Opt)
			return D.Default;
		}
	Die("GetDefaultOptValue(%s, %s), not found", Model.c_str(), Opt.c_str());
	ureturn(0);
	}

static void SetModelParams(const ModelAlgoData &MAD)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	const string &Algo = MAD.Algo;
	const string &Model = MAD.Model;

	const unsigned TransCount = SIZE(ctx->g_AlgoTrans);
	for (unsigned TransIndex = 0; TransIndex < TransCount; ++TransIndex)
		{
		const AlgoTransData &AT = ctx->g_AlgoTrans[TransIndex];
		if (AT.Algo == Algo)
			{
			const ModelOptTransData *MOT = GetModelTransOpt(Model, AT.Trans);
			if (MOT == 0)
				{
				*AT.Address = LOG_ZERO;
				if (ctx->opt_trace)
					Log("%s = *\n", AT.Trans.c_str());
				}
			else
				{
				float Value = GetOptValue(MOT->Opt);
				if (Value == FLT_MAX)
					{
					Value = GetDefaultOptValue(MAD.Model, MOT->Opt);
					if (ctx->opt_trace)
						Log("%s = %s = %g (default)\n", AT.Trans.c_str(), MOT->Opt.c_str(), Value);
					}
				else
					{
					if (ctx->opt_trace)
						Log("%s = %s = %g (command-line)\n", AT.Trans.c_str(), MOT->Opt.c_str(), Value);
					}

				*AT.Address = -Value;
				}
			}
		}
	}

void LogModels()
	{
/*	InitModelData();
	GB2::Muscle4Context *ctx = getMuscle4Context();
	const unsigned ModelCount = SIZE(ctx->g_ModelAlgo);
	const unsigned TransCount = SIZE(ctx->g_AlgoTrans);

	for (set<string>::const_iterator p = ctx->g_Algos.begin();
	  p != ctx->g_Algos.end(); ++p)
		{
		const string &Algo = *p;
		Log("\n");
		Log("Algo %s\n", Algo.c_str());

		vector<string> Models;
		for (unsigned ModelIndex = 0; ModelIndex < ModelCount; ++ModelIndex)
			{
			const ModelAlgoData &MA = ctx->g_ModelAlgo[ModelIndex];
			if (MA.Algo == Algo)
				Models.push_back(MA.Model);
			}

		vector<string> Transs;
		for (unsigned TransIndex = 0; TransIndex < TransCount; ++TransIndex)
			{
			const AlgoTransData AT = ctx->g_AlgoTrans[TransIndex];
			if (AT.Algo == Algo)
				Transs.push_back(AT.Trans);
			}

		const unsigned AlgoModelCount = SIZE(Models);
		Log("%5.5s", "Trans");
		for (unsigned i = 0; i < AlgoModelCount; ++i)
			Log("  %16.16s", Models[i].c_str());
		Log("\n");

		Log("-----");
		for (unsigned i = 0; i < AlgoModelCount; ++i)
			Log("  ----------------");
		Log("\n");

		for (unsigned TransIndex = 0; TransIndex < SIZE(Transs); ++TransIndex)
			{
			const string &Trans = Transs[TransIndex].c_str();
			Log("%5.5s", Trans.c_str());

			for (unsigned i = 0; i < AlgoModelCount; ++i)
				{
				const string &Model = Models[i];
				const ModelOptTransData *MOT = GetModelTransOpt(Model, Trans);
				string s = "-";
				if (MOT != 0)
					s = MOT->Opt;
				Log("  %16.16s", s.c_str());
				}

			Log("\n");
			}
		}*/
	}

static void GetSubstMxName(const string &Model, string &Name)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	if (ctx->opt_matrix != "")
		Name = ctx->opt_matrix;
	else if (Model == "localaffnuc" || Model == "globalaffnuc" || Model == "globalnuc")
		Name = "PCRNA";
	else
		Name = "PCCRFMX";
	}

void SetSubstMx(const string &Model)
	{
	string Name;
	if (Model.find('+') == string::npos)
		GetSubstMxName(Model, Name);
	else
		{
		vector<string> Fields;
		Split(Model, Fields, '+');
		if (Fields.size() != 2)
			Die("Invalid dual model %s", Model.c_str());

		const string &Model1 = Fields[0];
		const string &Model2 = Fields[1];

		string Name2;
		GetSubstMxName(Model1, Name);
		GetSubstMxName(Model2, Name2);
		
		if (Name2 != Name)
			Die("Invalid dual model, must use same subst matrix (%s,%s)",
			  Name.c_str(), Name2.c_str());
		}

	Mx<float> &SubstMxf = GetSubstMxf();
	if (SubstMxf.m_Name == Name)
		return;

	if (Name == "PCCRFMX")
		SetPCCRFMX();
	else if (Name == "HOXD70")
		SetHOXD70();
	else if (Name == "HOXD55")
		SetHOXD55();
	else if (Name == "PCRNA")
		SetPCRNA();
	else 
		ReadSubstMx(Name.c_str(), SubstMxf);
	}

FWD_BWD SetModel(const string &Model)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	if (ctx->opt_trace)
		{
		Log("\n");
		Log("SetModel(%s)\n", Model.c_str());
		}

	InitModelData();
	SetSubstMx(Model);

	for (unsigned i = 0; i < SIZE(ctx->g_ModelAlgo); ++i)
		{
		const ModelAlgoData &MAD = ctx->g_ModelAlgo[i];
		if (MAD.Model == Model)
			{
			if (ctx->g_Model != Model)
				{
				SetModelParams(MAD);
				ctx->g_Model = Model;
				}
			return GetFwdBwd(MAD.Algo);
			}
		}
	Die("SetModel(%s), not found", Model.c_str());
	ureturn(0);
	}

static void LogModelParamsMAD(const ModelAlgoData &MAD)
	{
/*	GB2::Muscle4Context *ctx = getMuscle4Context();
	const string &Algo = MAD.Algo;
	const string &Model = MAD.Model;

	const unsigned TransCount = SIZE(ctx->g_AlgoTrans);
	for (unsigned TransIndex = 0; TransIndex < TransCount; ++TransIndex)
		{
		const AlgoTransData &AT = ctx->g_AlgoTrans[TransIndex];
		if (AT.Algo == Algo)
			{
			const ModelOptTransData *MOT = GetModelTransOpt(Model, AT.Trans);
			if (MOT == 0)
				{
				*AT.Address = LOG_ZERO;
				Log("%s = *\n", AT.Trans.c_str());
				}
			else
				{
				float Value = GetOptValue(MOT->Opt);
				if (Value == FLT_MAX)
					{
					Value = GetDefaultOptValue(MAD.Model, MOT->Opt);
					Log("%s = %s = %g (default)\n", AT.Trans.c_str(), MOT->Opt.c_str(), Value);
					}
				else
					Log("%s = %s = %g (command-line)\n", AT.Trans.c_str(), MOT->Opt.c_str(), Value);
				}
			}
		}*/
	}

static void LogModelParamsModel(const string &Model)
	{
/*	GB2::Muscle4Context *ctx = getMuscle4Context();
	Log("Model %s\n", Model.c_str());
	string MxName;
	GetSubstMxName(Model, MxName);
	SetSubstMx(Model);
	GetSubstMxf().LogMe();
	Log("Matrix %s\n", MxName.c_str());
	for (unsigned i = 0; i < SIZE(ctx->g_ModelAlgo); ++i)
		{
		const ModelAlgoData &MAD = ctx->g_ModelAlgo[i];
		if (MAD.Model == Model)
			{
			Log("Algorithm %s\n", MAD.Algo.c_str());
			LogModelParamsMAD(MAD);
			}
		}*/
	}

void LogModelParams()
	{
/*	InitModelData();
	GB2::Muscle4Context *ctx = getMuscle4Context();
	const string &Model = ctx->opt_model;
	Log("\n");
	Log("Parameters:\n");
	vector<string> Models;
	Split(Model, Models, '+');
	const unsigned N = SIZE(Models);
	if (N > 1)
		Log("Multiple model: %s\n", Model.c_str());
	for (unsigned i = 0; i < SIZE(Models); ++i)
		{
		if (i > 0)
			Log("\n");
		LogModelParamsModel(Models[i]);
		} */
	}
