/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Muscle4Context.h"
#include <cstring>
#include <cstdlib>
#include <time.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <signal.h>
#include <float.h>

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

namespace GB2{

Muscle4Context::~Muscle4Context(){
	//g_MSAs.clear();
	for(unsigned i=0; i< g_InternalNodeMSAs.size(); i++){
		if(g_InternalNodeMSAs[i]!=0){
			delete g_InternalNodeMSAs[i];
		}
	}

	for(unsigned i=0; i<leaked_pointers.size(); i++){
		if(leaked_pointers[i]!=0){
			myfree(leaked_pointers[i]);
		}
	}

	for(unsigned i=0; i<leaked_arrays.size(); i++){
		if(leaked_arrays[i]!=0){
			myfree(leaked_arrays[i]);
		}
	}
	g_InternalNodeMSAs.clear();
	g_AlgoFwdBwd.clear();
	g_AlgoTrans.clear();
	g_ModelAlgo.clear();
	g_ModelOptTrans.clear();
	g_ModelOptDefaultHelp.clear();
	g_Opt.clear();
	g_Algos.clear();


	myfree(m_ColIndexBuffer);
	m_ColIndexBuffer = 0;
	delete g_Buffer2;
	delete g_Buffer1;
	//delete g_Input;
	delete m_RowValueBuffer;
	delete m_RowValueBuffer2;
	delete m_ColIndexBuffer2;
	//delete g_SimMxf;
}

Muscle4Context::Muscle4Context(){
	opt_input = ""; 
	opt_output = "";
	opt_model= "";	
	opt_matrix = "";	
	opt_subfamfiles = "";
	opt_outliers = "";
	opt_addseqs = "";
	opt_optimize = "";
	opt_self_aln = "";
	opt_maf = "";
	opt_labelregex = "";
	opt_posregex = "";
	opt_tree = "";
	opt_drawtree = "";
	opt_profile = "";	
	opt_blockprefix = "";

	opt_svnrevision = false;	
	opt_version = false;
	opt_inversions_only= false;
	opt_self_only= false;
	opt_msa_only= false;
	opt_xlat= false;
	opt_frameshift_only= false;
	opt_prune_only= false;

	opt_minsparseprob = 0.03;
	opt_mix = 0.5;
	opt_minlocalprob = 0.875;
	opt_minlocalid = 0.0;
	opt_gaplocal = 0.01;
	opt_mincolprob = 0.8;
	opt_maxmaskpct = 20.0;
	opt_prunedev = 1.0;
	opt_pruneacc = 0.5;
	opt_optimize_f = 4.0;
	opt_frameskew = 0.2;
	opt_gbpen = 8.0;

	opt_trace = false;
	opt_logmodels = false;
	opt_logparams = false;
	opt_eaweight = 	false;
	opt_refinecolprobs = false;
	opt_refineacc = false;
	opt_dotplots = 	false;
	opt_treeaftercons = false;
	opt_dualbest = false;
	opt_mixea = false;
	opt_self = true;
	opt_seqweights = true;
	opt_sumlog = false;
	opt_refinerand2 = true;
	opt_refinerand2e = false;
	opt_refinerand3 = false;
	opt_refinetree = false;
	opt_refinerandtree = true;
	opt_highprobupper = false;
	opt_inversions = true;
	opt_lowc = true;
	opt_msa = true;
	opt_subfams = true;
	opt_posteriors = false;
	opt_prune = false;
	opt_colprobs = false;
	opt_clustersize = true;
	opt_accweight = false;
	opt_localtree = false;
	opt_logtree = false;
	opt_treeorder = true;
	opt_alllocals = false;
	opt_allframes = false;
	opt_pruneid = false;
	opt_fasttree = false;
	opt_treeregex = false;
	opt_self1 = true;
	opt_onepass = false;
	opt_logfirstpasshits = false;
	opt_realignhits = true;
	opt_allblocks = false;
	opt_sw = false;
	opt_findrepmotifs = true;
	opt_mask = false;

	opt_cons = 1;
	opt_refine = 10;
	opt_smooth = 0;
	opt_minlocallen = 8;
	opt_mmband = 8;
	opt_maxlocalgap = 8;
	opt_maxlocaldi = 4;
	opt_arrangeov = 4;
	opt_rowlen = 64;
	opt_maxlabel = 16;
	opt_minreplen = 8;
	opt_subrefine = 0;
	opt_refinemix = 25;
	opt_maxseqlen = 10000;
	opt_framemin = 32;
	opt_maxbubble = 8;
	opt_posregexbase = 1;

	g_CurrProgressLineLength = 0;
	g_LastProgressLineLength = 0;
	g_CountsInterval = 0;
	g_TimeLastOutputStep = 0;

	g_fLog = 0;

	g_StartTime = time(0);
	g_PeakMemUseBytes = 0;
	
	//opt_quiet = false;
	//opt_logopts = false;
	//opt_compilerinfo = false;
	//opt_help = false;
	//opt_log = "";
	g_Buffer1Size = 0;
	g_Buffer2Size = 0;
	g_Buffer1 = 0;
	g_Buffer2 = 0;

	g_SubfamCounter = 0;
	g_NodeCounter = 0;

	g_BlockIndex = 0;
	g_ProgressCounter = 0;
	g_Input = 0;

	for(int i=0; i<65; i++){
		g_DNAIndexToAA[i] = 0;	
	}

	//InitDone = InitTable();
	g_MatrixFileCount = 0;
	sta = 0;

	g_TreeDepth = 0;

	PageSize = 1;

	 m_MaxNonZeroValuesPerRow=0;
	 m_RowValueBuffer=0;
	 m_ColIndexBuffer=0;
	 m_RowValueBuffer2=0;
	 m_ColIndexBuffer2=0;
	 m_TotalFractValuesBytes=0;
	 m_TotalColIndexesBytes=0;
	 m_TotalStartPosBytes=0;
	 m_TotalCellCount=0;
     m_TotalRowCount=0;


	m_RowValueBuffer=0;
	m_RowValueBuffer2=0;
	m_ColIndexBuffer2=0;
	
	//g_SimMxf = 0;
	 //m_Matrices = 0;

	 TransSM=0;
	 TransSD=0;
	 TransSI=0;
	 TransSX=0;
	 TransSY=0;

	 TransME=0;
	 TransDE=0;
	 TransIE=0;
	 TransXE=0;
	 TransYE=0;

	 TransMM=0;
	 TransDM=0;
	 TransIM=0;
	 TransXM=0;
	 TransYM=0;

	 TransMD=0;
	 TransMI=0;
	 TransMX=0;
	 TransMY=0;

	 TransDD=0;
	 TransII=0;
	 TransXX=0;
	 TransYY=0;

	 TransLMD=0;
	 TransLMI=0;
	 TransLMX=0;
	 TransLMY=0;

	 TransLDD=0;
	 TransLII=0;
	 TransLXX=0;
	 TransLYY=0;

	 TransRMD=0;
	 TransRMI=0;
	 TransRMX=0;
	 TransRMY=0;

	 TransRDD=0;
	 TransRII=0;
	 TransRXX=0;
	 TransRYY=0;

	 //leaked_arrays = 0;
}



Muscle4Exception::Muscle4Exception(const char* _str) {
    int len = strlen(_str);
    //assert(len < 4096);
    memcpy(str, _str, len);
    str[len] = '\0';
}

Muscle4Exception::Muscle4Exception() {
    memset(str, 4096, '\0');
}

void stopIfCanceled(GB2::TaskStateInfo& info){
	if(info.cancelFlag){
		 Muscle4Exception x("Muscle Exception occured");
		 throw x;
	}	
}
}
