/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

//#include "myopts.h"

#include "muscle4/myutils.h"

#ifndef _GB2_UMUSCLE_ADAPTER_H_
#define _GB2_UMUSCLE_ADAPTER_H_

#include <QtCore/QObject>

namespace GB2 {

class MAlignment;
class TaskStateInfo;
class MatrixContainer;
class Muscle4Context;

class Muscle4Adapter : public QObject {
Q_OBJECT
public:
	
    static void align(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti, bool mhack = true);

    static void refine(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti);

    static void align2Profiles(const MAlignment& ma1, const MAlignment& ma2, MAlignment& res, TaskStateInfo& ti);
    
    static void addUnalignedSequencesToProfile( const MAlignment& ma, const MAlignment& unalignedSeqs, MAlignment& res, TaskStateInfo& ti);

private:
    static void alignUnsafe(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti, bool mhack, MatrixContainer *mtx, Muscle4Context* ctx);
    
    static void refineUnsafe(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti);

    static void align2ProfilesUnsafe(const MAlignment& ma1, const MAlignment& ma2, MAlignment& res, TaskStateInfo& ti);

    static void addUnalignedSequencesToProfileUnsafe(const MAlignment& ma, const MAlignment& unalignedSeqs, MAlignment& res, TaskStateInfo& ti);
};

}//namespace

#endif