/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

//#include "vld.h"
#include "Muscle4Adapter.h"
#include "muscle4/seqdb.h"
#include "muscle4/myutils.h"
#include "muscle4/mx.h"
#include "muscle4/svnrevision.h"
#include "muscle4/params.h"
#include "muscle4/sparsemx.h"
#include "muscle4/hit.h"
#include "Muscle4Context.h"
#include "Muscle4TaskLocalStorage.h"

//#include "MuscleUtils.h"
//#include "MuscleConstants.h"

#include <core_api/DNAAlphabet.h>
#include <core_api/Task.h>
#include <core_api/Log.h>
#include <util_algorithm/GAutoDeleteList.h>
#include <datatype/MAlignment.h>

#include <algorithm>
#include <QtCore/QVector>
#include "qstring.h"
#include <exception>

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>


void ComputeSelfHitsDB(SeqDB& input);


namespace GB2 {

//static LogCategory log(ULOG_CAT_MUSCLE);

void Muscle4Adapter::align(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti, bool mhack) {
    
	MatrixContainer *mtx = new MatrixContainer();
	Muscle4TaskLocalData::bindContainer(mtx);
	
	Muscle4Context *ctx = new Muscle4Context();
	Muscle4TaskLocalData::bindContext(ctx);
	
	ctx->InitDone = InitTable();
	ctx->info = &ti;
	
	if(ti.cancelFlag)  {
		delete ctx;
		delete mtx;
        return;
    }
    try { 
        alignUnsafe(ma, res, ti, mhack, mtx, ctx);
    } catch (Muscle4Exception& e) {
        if (!ti.cancelFlag) {
            ti.setError(  tr("Internal MUSCLE error: %1").arg(e.str) );
        }
    }
	Muscle4TaskLocalData::detachContext();
	delete ctx;
	Muscle4TaskLocalData::detachMatrix();
	delete mtx;
}

void Muscle4Adapter::alignUnsafe(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti, bool mhack, MatrixContainer *mtx, Muscle4Context* ctx) {
	::MyCmdLine(0,0);
	SeqDB seqDB;
	ctx->info->progress = 5;

	unsigned i=0;
    unsigned seq_count = 0;
    
	foreach(const MAlignmentItem& item, ma.alignedSeqs) {
		QByteArray barray = item.name.toAscii();
		char* name =  barray.data();
		QByteArray *seq = new QByteArray(item.sequence);    
		ctx->leaked_arrays.push_back(seq);
		byte* data = (byte*)seq->data();
		int size = seq->size();
		seqDB.m_Seqs.push_back(data);
		seqDB.m_Labels.push_back(name);
		seqDB.m_Lengths.push_back(size);
		seq_count++;
    }
	
	unsigned TotalLength = 0;
	unsigned MaxLength = 0;
	bool m_Aligned = true;
	
	for (unsigned i = 0; i < seq_count; ++i)
		{
		unsigned Length = seqDB.m_Lengths[i];
		if (Length != seqDB.m_Lengths[0])
			m_Aligned = false;
		if (Length > MaxLength)
			MaxLength = Length;
		seqDB.m_Lengths.push_back(Length);
		seqDB.m_FullLengths.push_back(Length);
		TotalLength += Length;
		seqDB.m_Users.push_back(i);
		seqDB.m_Weights.push_back(1.0f);
		seqDB.m_Los.push_back(0);
		seqDB.m_Strands.push_back(true);
		}
	for(unsigned j =0; j< seq_count; j++){
			seqDB.StripGaps(j);
	}

	if (seqDB.GetSeqType() == ST_Amino)
		ctx->opt_model = "global+localaff";
	else
		ctx->opt_model = "globalnuc+localaffnuc";
	
	//ctx->info->setStateDesc(tr ("Computing self hits"));
	::ComputeSelfHitsDB(seqDB);
	ctx->info->progress = 10;
	seqDB.ClearSPPs();
	ctx->info->progress = 20;
	SeqDB &msa = seqDB.Align(ctx->opt_cons, ctx->opt_refine, ctx->opt_seqweights, ctx->opt_subfamfiles);
	ctx->info->progress = 100;
	 for(int i=0, n = msa.GetSeqCount(); i < n; i++) {
		const std::string& str = msa.m_Labels[i];
		QString qstr = "";
		qstr.append(str.c_str());
		QByteArray seq((const char*)msa.m_Seqs[i]);
		QByteArray seq2;
		for(unsigned j = 0; j<msa.m_Lengths[i]; j++){
			seq2.append(seq[j]);
		}
		seq.reserve(msa.GetColCount());
        MAlignmentItem item(qstr, seq2);
        res.alignedSeqs.append(item);      
    }
	
	res.alphabet = ma.alphabet;
	//delete seqDB;
	//_CrtDumpMemoryLeaks();
	//delete &msa;

}

//////////////////////////////////////////////////////////////////////////
// refine single MSA

void Muscle4Adapter::refine(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti) {
}

void Muscle4Adapter::refineUnsafe(const MAlignment& ma, MAlignment& res, TaskStateInfo& ti) {
}

} 
