/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "QtScriptDebugPlugin.h"
#include "QtScriptDebugViewController.h"

#include <core_api/MainWindow.h>
#include <core_api/Log.h>
#include <core_api/Settings.h>


#include <QtGui/QMenu>
#include <QtXml/QtXml>
#include <QtCore/QProcess>
#include <QtScript/QScriptEngine>

#define SETTINGS_ROOT QString("script_debuger/")


namespace GB2 {

static LogCategory log(ULOG_CAT_PLUGIN_SCRIPT_DEBUGGER);


extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    if (AppContext::getMainWindow()) {
        QtScriptDebugPlugin* plug = new QtScriptDebugPlugin();
        return plug;
    }
    return NULL;
}


QtScriptDebugPlugin::QtScriptDebugPlugin() : Plugin(tr("Script Debugger"), tr("Integrates script editor and debugger into UGENE")) {
    view=NULL;
    windowAction = new QAction(tr("Script Debuger"), this);
    windowAction->setIcon(QIcon(":script_debuger/images/bug.png"));
    connect(windowAction, SIGNAL(triggered()), SLOT(sl_showWindow()));
    AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu(MWMENU_TOOLS)->addAction(windowAction);
}

void QtScriptDebugPlugin::sl_showWindow() {
    
    if (view==NULL) {
        view = new QtScriptDebugViewController();
        view->installEventFilter(this);
        AppContext::getMainWindow()->getMDIManager()->addMDIWindow(view);
    }
    AppContext::getMainWindow()->getMDIManager()->activateWindow(view);
    
}

bool QtScriptDebugPlugin::eventFilter(QObject *obj, QEvent *event) {
    if (event->type() == QEvent::Close && obj == view) {

        view = NULL;
    }
    return QObject::eventFilter(obj, event);
}
}//namespace
