/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RepeatFinderPlugin.h"
#include "RepeatFinderTests.h"
#include "RepeatWorker.h"
#include "FindRepeatsDialog.h"

#include <core_api/DNAAlphabet.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAViewFactory.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>
#include <util_algorithm/GAutoDeleteList.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTestFrameworkComponents.h>

#include <QtGui/QMenu>
#include <QtGui/QAction>

#include <cstdio>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    RepeatFinderPlugin* plug = new RepeatFinderPlugin();
    return plug;
}

RepeatFinderPlugin::RepeatFinderPlugin() : Plugin("Repeats Finder", "Search for repeated elements in genetic sequences"), viewCtx(NULL) {
    if (AppContext::getMainWindow()) {
        viewCtx = new RepeatViewContext(this);
        viewCtx->init();
    }
    LocalWorkflow::RepeatWorkerFactory::init();
    
    //tests
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = RepeatFinderTests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        assert(res); Q_UNUSED(res);
    }

}

RepeatViewContext::RepeatViewContext(QObject* p) : 
GObjectViewWindowContext(p, AnnotatedDNAViewFactory::ID) 
{
}

void RepeatViewContext::initViewContext(GObjectView* v) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
    ADVGlobalAction* a = new ADVGlobalAction(av, QIcon(":repeat_finder/images/repeats.png"), tr("Find Repeats"), 40);
    a->addAlphabetFilter(DNAAlphabet_NUCL);
    connect(a, SIGNAL(triggered()), SLOT(sl_showDialog()));
}

void RepeatViewContext::sl_showDialog() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    ADVSequenceObjectContext* sctx = av->getSequenceInFocus();
    assert(sctx!=NULL && sctx->getAlphabet()->isNucleic());
    FindRepeatsDialog d(sctx);
    d.exec();
}

}//namespace
