/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEND_SELECTION_DIALOG_IMPL_H_
#define _GB2_SEND_SELECTION_DIALOG_IMPL_H_

#include <ui/ui_SendSelectionDialog.h>
#include "RemoteRequestPlugin.h"

#include <core_api/GObjectReference.h>

#include <gobjects/DNASequenceObject.h>

#include <QtCore/QList>

namespace GB2 {

class CreateAnnotationWidgetController;
class AnnotationTableObject;

class SendSelectionDialogImpl : public QDialog,  Ui_SendSelectionDialog {
    Q_OBJECT
public:
    SendSelectionDialogImpl( QList<Script *> _scripts, const DNASequenceObject* dnaso, bool _isAminoSeq, QWidget *p = NULL );
    QString getGroupName() const;
    AnnotationTableObject* getAnnotationObject() const;
private slots:
    void sl_scriptSelected( int index );
    void sl_customSettings();
    void sl_minResLenChanged( int i );
    void sl_maxResLenChanged( int i );
    void sl_OK();

private:
    void setupScriptsList();
    void setupAlphabet();
    void setupStrand();

public:
    int maxResultLen;
    int minResultLen;
    int maxQueryLen;
    SendSelectionStrand strand;
    SendSelectionAlphabet alpha;
    Script * chosen;

private:

    QList< Script * > scripts;
    bool isAminoSeq;
    CreateAnnotationWidgetController * ca_c;
    QScriptEngine engine;
    bool extImported;
};

} //namespace

#endif
