/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_DIALOG_CONTROLLER_H_
#define _GB2_EXPORT_DIALOG_CONTROLLER_H_

#include <core_api/core_api.h>

#include <QtGui/QDialog>
#include <ui/ui_DNAExportDialog.h>

namespace GB2 {



class ExportDialogController : public QDialog, Ui_DNAExportDialog {
    Q_OBJECT
public:
    ExportDialogController(bool multiMode, bool allowComplement, bool allowTranslation, const DocumentFormatId& f);

    void updateModel();
    bool multiMode;
    DocumentFormatId formatId;
    QString file;
    
    TriState strand;//Yes-> direct, No->complement, Unkn -> both
    bool translate;
    bool translateAllFrames;

    bool merge;
    int mergeGap;

private slots:
    void sl_exportClicked();
    void sl_fileClicked();

};

}//namespace

#endif
