/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SAVE_DOCUMENT_TASK_H_
#define _GB2_SAVE_DOCUMENT_TASK_H_

#include <core_api/Task.h>
#include <gobjects/UnloadedObject.h>

#include <QtCore/QPointer>

namespace GB2 {

class Document;
class StateLock;
class IOAdapterFactory;
class DocumentFormat;

class GB2_COREAPI_EXPORT SaveDocumentTask : public Task {
    Q_OBJECT
public:
	SaveDocumentTask(Document* doc, IOAdapterFactory* iof = NULL, const QString& url = QString::null, bool ensureExt = true);
    SaveDocumentTask(Document* doc, uint flags);

	virtual void prepare();

	virtual void run();

	ReportResult report();

    const QString& getURL() const {return url;}

    IOAdapterFactory* getIOAdapterFactory() const {return iof;}

    const QPointer<Document>& getDocument() const {return doc;}
private:
	StateLock*          lock;
    QPointer<Document>  doc;
	IOAdapterFactory*   iof;
	QString             url;
    uint                flags;
};


class GB2_COREAPI_EXPORT SaveMiltipleDocuments: public Task {
    Q_OBJECT
public:

	SaveMiltipleDocuments(const QList<Document*>& docs, bool askBeforeSave);

	static QList<Document*> findModifiedDocuments(const QList<Document*>& docs);
};

enum UnloadDocumentTask_SaveMode {
    UnloadDocumentTask_SaveMode_Ask,
    UnloadDocumentTask_SaveMode_NotSave,
    UnloadDocumentTask_SaveMode_Save
};


class GB2_COREAPI_EXPORT UnloadDocumentTask: public Task {
    Q_OBJECT
public:
    UnloadDocumentTask(Document* doc, bool save);
    ReportResult report();

    static void runUnloadTaskHelper(const QList<Document*>& docs, UnloadDocumentTask_SaveMode sm);
    static QString checkSafeUnload(Document* d);

private:
    QPointer<Document>      doc;
    SaveDocumentTask*       saveTask;
};

class GB2_COREAPI_EXPORT SaveCopyAndAddToProjectTask : public Task {
    Q_OBJECT
public:
    SaveCopyAndAddToProjectTask(Document* doc, IOAdapterFactory* iof, const QString& url, bool ensureExt = true);
    ReportResult report();
private:
    SaveDocumentTask*           saveTask;
    QList<UnloadedObjectInfo>   info;
    QString                     url;
    QString                     origURL;
    DocumentFormat*             df;
    QVariantMap                 hints;
};


class GB2_COREAPI_EXPORT RelocateDocumentTask : public Task {
    Q_OBJECT
public:
    RelocateDocumentTask(const QString& fromURL, const QString& toURL);
    ReportResult report();

public:
    QString fromURL;
    QString toURL;
};

}//namespace

#endif
