/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOVE_PART_FROM_SEQUENCE_TASK_H_
#define _GB2_REMOVE_PART_FROM_SEQUENCE_TASK_H_

#include <core_api/Task.h>
#include <core_api/DocumentModel.h>
#include <gobjects/DNASequenceObject.h>

namespace GB2 {

class GB2_COREAPI_EXPORT RemovePartFromSequenceTask : public Task {
    Q_OBJECT
public:
    enum AnnotationStrategyForRemove{
        AnnotationStrategyForRemove_Resize, 
        AnnotationStrategyForRemove_Remove
    };
    RemovePartFromSequenceTask(DocumentFormatId _dfId, DNASequenceObject *_seqObj, LRegion _regionToDelete, 
        AnnotationStrategyForRemove _str = AnnotationStrategyForRemove_Resize, QString _url = QString(), bool _mergeAnnotations = false);
    virtual Task::ReportResult report();

private:
    void fixAnnotations();
    void preparationForSave();

    DocumentFormatId dfId;
    bool mergeAnnotations;
    Document *curDoc;
    Document *newDoc;
    bool save;
    QString url;
    AnnotationStrategyForRemove strat;
    QList<Document*> docs;
    DNASequenceObject *seqObj;
    LRegion regionToDelete;
};

}//ns

#endif
