/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_REPORT_CALLBACK_H_
#define _GB2_SMITH_WATERMAN_REPORT_CALLBACK_H_

#include <util_smith_waterman/SmithWatermanResult.h>

// for impl
#include <QObject>
#include <gobjects/AnnotationTableObject.h>
// for impl

namespace GB2 {

class GB2_COREAPI_EXPORT SmithWatermanReportCallback {
public:
    virtual QString report(const QList<SmithWatermanResult>& lst) = 0;
    virtual ~SmithWatermanReportCallback() {};
};

class GB2_COREAPI_EXPORT SmithWatermanReportCallbackImpl:  
                                        public QObject,
                                        public SmithWatermanReportCallback {
    Q_OBJECT
public:
    SmithWatermanReportCallbackImpl(AnnotationTableObject* _aobj,
                                    const QString& _annotationName,
                                    const QString& _annotationGroup, 
                                    QObject* pOwn = 0);

    virtual QString report(const QList<SmithWatermanResult>& result);
    SmithWatermanResultListener* getListener();
    const QList<SharedAnnotationData>& getAnotations() const {return anns;}
private:
    SmithWatermanResultListener rl;

    QString annotationName;
    QString annotationGroup;
    QPointer<AnnotationTableObject> aObj;
    QList<SharedAnnotationData> anns;
    bool    autoReport;
};

} // namespace

#endif
