/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEC_STRUCT_PREDICT_TASK_H_
#define _GB2_SEC_STRUCT_PREDICT_TASK_H_

#include <QtCore/QObject>
#include <core_api/Task.h>
#include <datatype/AnnotationData.h>

namespace GB2 {

class GB2_COREAPI_EXPORT SecStructPredictTask : public Task {
    Q_OBJECT
public:
    SecStructPredictTask(const QByteArray& seq);
    const QList<SharedAnnotationData>& getResults() const { return results; }
    const QByteArray getSSFormatResults() const { return output; }
    
protected:
    QByteArray sequence, output;
    QList<SharedAnnotationData> results;
};


class GB2_COREAPI_EXPORT SecStructPredictTaskFactory {
public:
    virtual SecStructPredictTask* createTaskInstance(const QByteArray& inputSeq) = 0;
    virtual ~SecStructPredictTaskFactory() {}
};

#define SEC_STRUCT_PREDICT_TASK_FACTORY(c) \
public: \
    static const QString taskName; \
    class Factory : public SecStructPredictTaskFactory { \
    public: \
        Factory() { } \
        SecStructPredictTask* createTaskInstance(const QByteArray& inputSeq) { return new c(inputSeq); } \
    };


} //namespace

#endif // _GB2_SEC_STRUCT_PREDICT_TASK_H_
