/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MALIGNMENT_OBJECT_H_
#define _GB2_MALIGNMENT_OBJECT_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>
#include <datatype/MAlignment.h>

#include "GObjectTypes.h"

namespace GB2 {

class GHints;
class DNASequence;

#define MA_OBJECT_NAME QString("Multiple alignment")

class MAlignmentModInfo {
public:
    MAlignmentModInfo() : sequenceContentChanged(true), sequenceListChanged(true) {}
    bool sequenceContentChanged;
    bool sequenceListChanged;
};

class GB2_COREAPI_EXPORT MAlignmentObject : public GObject {
    Q_OBJECT
public:

    MAlignmentObject(const MAlignment& a, const QVariantMap& hintsMap = QVariantMap())
        : GObject(GObjectTypes::MULTIPLE_ALIGNMENT, a.getName(), hintsMap), msa(a){};

    const MAlignment& getMAlignment() const {return msa;}

    char getBase(int seqNum, int pos) const {return msa.getBase(seqNum, pos);}

    virtual GObject* clone() const;

    void insertGap(int seqNum, int pos, int nGaps);
    
    void insertGap(int pos, int nGaps);

    int deleteGap(int seqNum, int pos, int maxGaps);
    
    int deleteGap(int pos, int maxGaps);

    void addSequence(const DNASequence& seq, int seqIdx);

    void removeSequence(int seqNum);

    void setMAlignment(const MAlignment& ma);

    virtual void setGObjectName(const QString& newName);

signals:
    void si_alignmentChanged(const MAlignment& maBefore, const MAlignmentModInfo& modInfo);
    
protected:
    MAlignment msa;
};

}//namespace


#endif
