/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_STARTER_H_
#define _GB2_WORKFLOW_STARTER_H_

#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <workflow_support/WorkflowIOTasks.h>

#include <workflow/WorkflowEnv.h>
#include <workflow_support/WorkflowUtils.h>
#include <workflow_support/WorkflowRunTask.h>

namespace GB2 {

class WorkflowStarter : public Task {
    Q_OBJECT
public:
    WorkflowStarter(const QStringList& urls);
    virtual ~WorkflowStarter();

    virtual void prepare();
    virtual ReportResult report();
protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);
private:
    QStringList                 urls;
    QList<Schema*>              shList;
};
} //namespace

#endif
