/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MAINWINDOW_IMPL_
#define _GB2_MAINWINDOW_IMPL_

#include <core_api/MainWindow.h>

#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>
#include <QtGui/QMenu>

class QMdiArea;
class QToolBar;

namespace GB2 {

class MWDockManagerImpl;
class MWMenuManagerImpl;
class MWToolBarManagerImpl;



class MainWindowImpl: public MainWindow {
    Q_OBJECT
public:
	MainWindowImpl();
	~MainWindowImpl();
    virtual MWMenuManager*          getMenuManager() const {return menuManager;}
    virtual MWToolBarManager*       getToolBarManager() const {return toolbarManager;}
    virtual MWMDIManager*           getMDIManager() const {return mdiManager;}
    virtual MWDockManager*          getDockManager() const {return dockManager;}
    virtual QMainWindow*            getQMainWindow() const {return mw;}

	virtual void setWindowTitle(const QString& title);
    
    QMainWindow* getMW() const {return mw;}

    void show();
    void close();

	void runClosingTask();

private slots:
	void sl_exitAction();
    void sl_aboutAction();
    void sl_checkUpdatesAction();
    void sl_visitWeb();

private:
    void createActions();
    void prepareGUI();

    QMainWindow*			mw;
    QMdiArea*				mdi;
    
    MWMenuManager*			menuManager;
	MWToolBarManager*		toolbarManager;
    MWMDIManager*			mdiManager;
    MWDockManager*			dockManager;

    QAction*				exitAction;
    QAction*				aboutAction;
    QAction*				checkUpdateAction;
    QAction*                visitWebAction;
};

}//namespace

#endif
