/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE_ALIGN_DIALOG_CONTROLLER_H_
#define _GB2_MUSCLE_ALIGN_DIALOG_CONTROLLER_H_

#include <util_algorithm/GAutoDeleteList.h>

#include <ui/ui_MuscleAlignDialog.h>
#include "MuscleTask.h"

#include <QtGui/QDialog>

namespace GB2 {

class MuscleAlignPreset {
public:
    virtual ~MuscleAlignPreset(){}
    virtual void apply(MuscleTaskSettings& ts) const = 0;

    QString name;
    QString desc;
};

class DefaultModePreset : public MuscleAlignPreset {
public:
    DefaultModePreset();
    virtual void apply(MuscleTaskSettings& ts) const {
        //no options
        ts.reset();
    }
};

class LargeModePreset : public MuscleAlignPreset {
public:
    LargeModePreset();

    virtual void apply(MuscleTaskSettings& ts) const {
        ts.reset();
        ts.maxIterations = 2;
    }
};

class RefineModePreset : public MuscleAlignPreset {
public:
    RefineModePreset();
    virtual void apply(MuscleTaskSettings& ts) const {
        ts.reset();
        ts.op = MuscleTaskOp_Refine;
    }
};


class MuscleAlignDialogController : public QDialog, public Ui_MuscleAlignmentDialog {
    Q_OBJECT

public:
    MuscleAlignDialogController(QWidget* w, const MAlignment& ma, MuscleTaskSettings& settings);
    
public slots:
    void accept();

private slots:
    void sl_onPresetChanged(int current);

private:
    void initPresets();

    MAlignment                          ma;
    MuscleTaskSettings&                 settings;
    GAutoDeleteList<MuscleAlignPreset>  presets;
};



}//namespace
#endif
