/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <string>
#include <iostream>

#include "SubstitutionMatrix.h"
#include <qfile.h>

using namespace std;

int SubstitutionMatrix::getSubstituteValue(char symbol1, char symbol2) const {
	return matrix.at(alphabet.indexOf(symbol1)).at(alphabet.indexOf(symbol2));
}

//Read from a file named pathToFile.
// bool SubstitutionMatrix::openFile(QString pathToFile) {	
// 	
// 	QFile data;
// 	data.setFileName(pathToFile);	
// 	
// 	
// 	if (data.open(QFile::ReadOnly)) {		
// 		file.setDevice(&data);		
// 	}
// 	else {
// 		cout << "Error: Can't open the file named " <<pathToFile.toStdString() <<endl;		
// 		return false;
// 	}	
// 
// 	return true;
// }

//Read and save values from a file named pathToFile
bool SubstitutionMatrix::readMatrixFromFile(QString pathToFile) {		

	QFile data;
	QTextStream file;
	data.setFileName(pathToFile);	


	if (data.open(QFile::ReadOnly)) {		
		
		file.setDevice(&data);				
				
			QString str;			
			char ch = ' ';
			str = file.readLine();
			

//Skip comments (begin with '#')				
				
				while (!str.isNull() && -1 != str.indexOf('#'))	str = file.readLine();				
				
//Remove spaces from string and save alphabet
				removeSpacesFromString(str);				
				alphabet = str;
				
//Initialization squarte matrix

//Begin cycle for rows
				int number = 0;
				for (int i = 0; i < alphabet.length(); i++) {					
					QVector<int> buffer;
//Read symbol of alphabet
					ch = ' ';					
					while (!file.atEnd() && (' ' == ch || '\n' == ch)) {
						file >>ch; 											
					}					
//Check symbol's position such that matrix be square					
					if (ch == alphabet.at(i)) 
//Begin cycle for columns						
						for (int j = 0; j < alphabet.length(); j++) {							
							file >> number;
							buffer.append(number);
					}
					else return false;
//Store data to 'matrix' variable
					matrix.append(buffer);
					buffer.clear();
				}
/*
//Print Matrix
				cout <<"**********************Matrix***************" <<endl;
				for (int i = 0; i < alphabet.length(); i++) {
					for (int j = 0; j < alphabet.length(); j++) cout <<matrix[i][j] <<" ";  
					cout <<endl;
				}
				cout <<"********************************************" <<endl;					
*/				
				return true;
		}
		return false;			
}		


//Remove Spaces From String
void SubstitutionMatrix::removeSpacesFromString(QString &str) {
		while ( -1 != str.indexOf(' ')) {
			int firstSymbol = str.indexOf(' ');		
			str.replace(firstSymbol, 1 , "");		
	}
}

