/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SCRIPT_ENGINE_CONTEXT_H_
#define _GB2_SCRIPT_ENGINE_CONTEXT_H_

#include <QtScript/QScriptable>
#include <datatype/AnnotationData.h>
#include <core_api/ScriptRegistry.h>
#include <core_api/Log.h>
#include <core_api/Task.h>

class QScriptEngine;
namespace GB2
{

class ScriptTypes {   
public:
    static const QString SCRIPT_TYPE_HTTP_ANNOTATOR;
};

enum HttpAnnotatorAlphabet {
    HttpAnnotatorAlphabet_Any,
    HttpAnnotatorAlphabet_Nucleo,
    HttpAnnotatorAlphabet_Amino
};

enum HttpAnnotatorStrand {
    HttpAnnotatorStrand_Unknown,
    HttpAnnotatorStrand_Single,
    HttpAnnotatorStrand_Both
};

class AnnotationDataPrototype : public QObject, public QScriptable {
    Q_OBJECT
    Q_PROPERTY( bool complement READ complement WRITE setComplement )
    Q_PROPERTY( QString name READ name WRITE setName )
public:
    AnnotationDataPrototype( QObject * o = 0);

    bool complement() const;
    void setComplement( bool c );

    QString name() const;
    void setName( const QString & name );

    Q_INVOKABLE void setAlpha( bool amino );
    Q_INVOKABLE void addLocation( int start, int len );
    Q_INVOKABLE void addQualifier( const QString & name, const QString & val );
    Q_INVOKABLE QString toString() const;
    Q_INVOKABLE int getSummaryLen() const;
};

class LogCategoryPrototype : public QObject, public QScriptable {
    Q_OBJECT
public:
    LogCategoryPrototype( QObject * o = 0 );

    Q_INVOKABLE void info( QString msg );
    Q_INVOKABLE void error( QString msg );
    Q_INVOKABLE void debug( QString msg );
};

class TaskStateInfoPrototype : public QObject, public QScriptable {
    Q_OBJECT
    Q_PROPERTY( int progress READ progress WRITE setProgress )
    Q_PROPERTY( bool cancelFlag READ cancelFlag WRITE setCancelFlag )
    Q_PROPERTY( QString stateDesc READ stateDesc WRITE setStateDesc )
    Q_PROPERTY( QString error READ error WRITE setError)    
public:
    TaskStateInfoPrototype( QObject * o = 0 );
    int progress() const;
    void setProgress( int );
    bool cancelFlag() const;
    void setCancelFlag( bool );
    QString stateDesc() const;
    void setStateDesc( QString );
    QString error() const;
    void setError( QString );
};

class ScriptHttpAnnotatorContext : QObject {
    Q_OBJECT
public:
    static void setDefaultProperties( QScriptEngine * engine );
    static void setQuery( QScriptEngine * engine, const QString & q );
    static void setMaxResLen( QScriptEngine * engine, int maxrl );
    static void setMinResLen( QScriptEngine * engine, int minrl );
    static void setLog( QScriptEngine * engine, LogCategory * lc );
    static void setTaskStateInfo( QScriptEngine * engine, TaskStateInfo * tsi );
    static int getMaxQueryLen( QScriptEngine * engine );
    static bool hasCustomSettings( QScriptEngine * engine );
    static HttpAnnotatorAlphabet getAlphabet( QScriptEngine * engine, QString * alpha_str );
    static HttpAnnotatorStrand   getStrand( QScriptEngine * engine );
    static QList<SharedAnnotationData> getAnnotations( QScriptEngine * engine );
    static void callCustomSettings( QScriptEngine * engine );
};

} //namespace


Q_DECLARE_METATYPE( GB2::AnnotationData * )
Q_DECLARE_METATYPE( GB2::LogCategory * )
Q_DECLARE_METATYPE( GB2::TaskStateInfo * )

#endif
