/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RemoteRequestPluginTests.h"

#include <core_api/DocumentModel.h>
#include <document_format/GenbankPlainTextFormat.h>
#include <gobjects/DNASequenceObject.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <gobjects/GObjectTypes.h>
#include <gobjects/GObjectUtils.h>
#include <core_api/GObject.h>
#include <core_api/AppContext.h>
#include <QtXml/QDomElement>
#include <core_api/IOAdapter.h>

/* TRANSLATOR GB2::GTest */

namespace GB2 {

#define EXPECTED_ATTR "expected_results"
#define MIN_LEN_ATTR "min_length"
#define MAX_LEN_ATTR "max_length"
#define STRAND_ATTR "strand"
#define SCRIPT_ATTR "script"
#define SCRIPT_ATTR_DEV "script_dev"
#define INDEX_ATTR "index"
#define SEQUENCE_ATTR "seq"

void GTest_RemoteRequest::init(XMLTestFormat *tf, const QDomElement& el) {
    Q_UNUSED(tf);
    
    ao = NULL;
    task = NULL;
    script = NULL;

    sequence = el.attribute(SEQUENCE_ATTR).toAscii();
    if (sequence.isEmpty()) {
        failMissingValue(SEQUENCE_ATTR);
        return;
    } 
    bool isOk;
    maxLength = el.attribute(MAX_LEN_ATTR).toInt(&isOk);
    if (!isOk) {
        stateInfo.setError(  QString("value not set %1, or unable to convert to integer ").arg(MAX_LEN_ATTR) );
        return;
    }

    minLength = el.attribute(MIN_LEN_ATTR).toInt(&isOk);
    if (!isOk) {
        stateInfo.setError(  QString("value not set %1, or unable to convert to integer ").arg(MIN_LEN_ATTR) );
        return;
    }

    QString scriptPath = el.attribute(SCRIPT_ATTR);
    if (scriptPath.isEmpty()) {
        failMissingValue(SCRIPT_ATTR);
        return;
    }
    QString scriptPathDev = el.attribute(SCRIPT_ATTR_DEV);
    if (scriptPathDev.isEmpty()) {
        failMissingValue(SCRIPT_ATTR_DEV);
        return;
    }
    
    script = new Script(scriptPath);
    if(!script->reload()) {
        script = new Script(scriptPathDev);
        if (!script->reload())
        {
            stateInfo.setError(  QString("Problems while loading script file %1").arg(scriptPath) );
            script=NULL;
            return;
        }
    } 
        
    QString strandStr = el.attribute(STRAND_ATTR);
    if (strandStr.isEmpty()) {
        failMissingValue(STRAND_ATTR);
        return;
    }
    if (strandStr == "direct") {
        strand = SendSelectionStrand_Direct;
    }else if(strandStr == "compliment") {
        strand = SendSelectionStrand_Complement;
    }else if (strandStr == "both") {
        strand = SendSelectionStrand_Both;
    }else {
        stateInfo.setError(  QString("%1 has incorrect value").arg(STRAND_ATTR) );
        return;
    }

    QString expected = el.attribute(EXPECTED_ATTR);
    if (!expected.isEmpty()) {
        QStringList expectedList = expected.split(QRegExp("\\,"));
        foreach(QString id, expectedList) {
            expectedResults.append(id);
        }
    }
}

void GTest_RemoteRequest::prepare() {
    DNAAlphabet *alp = AppContext::getDNAAlphabetRegistry()->findAlphabet(sequence);
    DNASequenceObject mySequence("seq", DNASequence(sequence, alp));
    QByteArray query(sequence);
    DNATranslation  *complT = GObjectUtils::findComplementTT(&mySequence), 
                    *aminoT = GObjectUtils::findAminoTT(&mySequence, true);
    ao = new AnnotationTableObject("aaa");
//     IOAdapterFactory* iof = AppContext::getIOAdapterRegistry()->getIOAdapterFactoryById(BaseIOAdapters::LOCAL_FILE);
//     DocumentFormat* df = AppContext::getDocumentFormatRegistry()->getFormatById(BaseDocumentFormats::PLAIN_GENBANK);
//     Document* d = df->createNewDocument(iof, env->getVar("TEMP_DATA_DIR") + "/" + getTaskName());
//     d->addObject(ao);
//    AppContext::getProject()->addDocument(d);
    task = new RemoteRequestTask(script, maxLength, minLength, strand, complT, aminoT, query, 0, ao, QString("result"));
    addSubTask(task);
}

Task::ReportResult GTest_RemoteRequest::report() {
    QStringList result;
    if (ao != NULL){
        QList<Annotation*> alist(ao->getAnnotations());
        foreach(Annotation *an, alist) {
            foreach(Qualifier q, an->getQualifiers()){
                if (q.getQualifierName() == "id") {
                    QString str(q.getQualifierValue());
                    int cnt(0);
                    QString toInsert, scrName = script->getName();
                    if(scrName == "BLASTn" || scrName == "BLASTp")                    {
                        for(int i = 0; i != str.size(); i++){
                            if(QString(str.at(i)) == QString("|")){
                                cnt++;
                                if (cnt == 2){
                                    i++;
                                    toInsert = str.right(str.size() - i);
                                }
                            }
                        }
                    } else {
                        toInsert = str;
                    }
                    result.append(toInsert);
                }
            }
        }
    }
    
    if(result.size() != expectedResults.size()){
        stateInfo.setError(  QString("Expected and Actual sizes of lists of regions are different: %1 %2").arg(expectedResults.size()).arg(result.size()) );
        return ReportResult_Finished;
    }
    result.sort(); expectedResults.sort();
    QStringListIterator e(expectedResults), a(result);
    for(; e.hasNext();){
        QString exp = e.next(), act =  a.next();
    }
    if(result != expectedResults) {
        stateInfo.setError(  QString("Expected and actual id's not equal") );
        return ReportResult_Finished;
    }
    return ReportResult_Finished;
}

void GTest_RemoteRequest::cleanup() {
    if(ao != NULL){
        //AppContext::getProject()->removeDocument(ao->getDocument(), true);
        delete ao;
        ao = NULL;
    }
    if (script != NULL){
        delete script;
        script = NULL;
    }
}

}//ns
