/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATOR_TESTS_H_
#define _GB2_ANNOTATOR_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include <test_framework/xmltest/DocumentModelTests.h>
#include <core_api/LRegion.h>
#include <gobjects/AnnotationTableObject.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include "CollocationsDialogController.h"

namespace GB2 {

class GTest_AnnotatorSearch : public GTest {
	Q_OBJECT
public:
	SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_AnnotatorSearch, "plugin_dna-annotator-search");

        ~GTest_AnnotatorSearch(){}
	
	void prepare();
    void cleanup();
	Task::ReportResult report();
private:
	QString seqName;
	QString docName;
	QString resultDocContextName;
	QSet<QString> groupsToSearch;
	int regionSize;
	CollocationsAlgorithm::SearchType st;
	CollocationSearchTask *searchTask;
	QList<LRegion> expectedResults;
};

} //namespace
#endif
