/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOAD_REMOTE_DOCUMENT_TASK_H_
#define _GB2_LOAD_REMOTE_DOCUMENT_TASK_H_

#include <core_api/DocumentFormats.h>
#include <core_api/Task.h>
#include <QtCore/QUrl>


namespace GB2 {

class CopyDataTask;
class LoadDocumentTask;


class GB2_COREAPI_EXPORT RecentlyDownloadedCache : public QObject {
    Q_OBJECT
    QMap<QString, QString> urlMap;
    void loadCacheFromSettings();
    void saveCacheToSettings();
public:
    RecentlyDownloadedCache();
    ~RecentlyDownloadedCache();
    bool contains(const QString& fileName) { return urlMap.contains(fileName); }
    void append(const QString& fullPath);
    QString getFullPath(const QString& fileName);

};


class GB2_COREAPI_EXPORT LoadRemoteDocumentTask : public Task {
    Q_OBJECT
public:
    LoadRemoteDocumentTask(const QString& fileUrl, const DocumentFormatId& formatId = "");
    virtual void prepare();
    virtual ReportResult report();
protected:
    QList<Task*> onSubTaskFinished(Task* subTask);
private:
   bool initLoadDocumentTask();
   DocumentFormatId formatId;
   CopyDataTask* copyDataTask;
   LoadDocumentTask* loadDocumentTask;
   QString url_from;
   QString fileName;
   QString fullPath;
};



} //namespace

#endif // _GB2_LOAD_REMOTE_DOCUMENT_TASK_H_
