/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SmithWatermanReportCallback.h"
#include <core_api/Log.h>

#include <QObject>

namespace GB2 {

static LogCategory log(ULOG_CAT_SW);

QString SmithWatermanReportCallbackImpl::report(const QList<SmithWatermanResult>& results) {
    
    if (autoReport && aObj.isNull()) {
        return tr("Annotation object not found.");
    }

    if (autoReport && aObj->isStateLocked()) {
        return tr("Annotation table is read-only");
    }

	foreach (const SmithWatermanResult& res , results) {		
		anns.append(res.toAnnotation(annotationName));
	}
    if (autoReport) {
	    QList<Annotation*> annotations;
	    foreach(const SharedAnnotationData& ad, anns) {
		    annotations.append(new Annotation(ad));
	    }
        aObj->addAnnotations(annotations, annotationGroup);
    }
    return QString();
}

SmithWatermanReportCallbackImpl::SmithWatermanReportCallbackImpl(
                                AnnotationTableObject* _aobj,
                                const QString& _annotationName,
                                const QString& _annotationGroup,
                                QObject* pOwn)
: QObject(pOwn), annotationName(_annotationName), annotationGroup(_annotationGroup), 
aObj(_aobj), autoReport(_aobj != NULL)
{
}

SmithWatermanResultListener* SmithWatermanReportCallbackImpl::getListener() {
    return &rl;
}

} // namespace
