/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SCRIPT_MODULUE_REGISTRY_H_
#define _GB2_SCRIPT_MODULUE_REGISTRY_H_

#include <core_api/core_api.h>

#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtScript/QScriptValue>
#include <QtScript/QScriptEngine>
#include <QtCore/QStringList>

namespace GB2 {

class GB2_COREAPI_EXPORT GScriptModule : public QObject {
public:
    QString moduleName;
    virtual void setup(QScriptEngine *engine) const =0;
private:    
};

class GB2_COREAPI_EXPORT GScriptModuleRegistry : public QObject {
    Q_OBJECT
public:
    GScriptModuleRegistry(QObject* p = NULL);
	
    GScriptModule* getModuleByName(const QString& moduleName)const {return gscriptModuleByName.value(moduleName);}
    void registerGScriptModule(GScriptModule* value);

private:

    QMap<QString,GScriptModule*> gscriptModuleByName;
};

}//namespace

#endif
