/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DNASequenceObject.h"

#include "GObjectTypes.h"

#include <core_api/DNAAlphabet.h>

namespace GB2 {

DNASequenceObject::DNASequenceObject(const QString& name, const DNASequence& seq, const QVariantMap& hintsMap) 
: GObject(GObjectTypes::DNA_SEQUENCE, name, hintsMap), dnaSeq(seq)
{
    assert(dnaSeq.alphabet!=NULL);
    seqRange = LRegion(0, dnaSeq.seq.length());
}

GObject* DNASequenceObject::clone() const {
	DNASequenceObject* cln = new DNASequenceObject(getGObjectName(), dnaSeq, getGHintsMap());
    cln->setIndexInfo(getIndexInfo());
    return cln;
}

void DNASequenceObject::setBase(int pos, char base) {
	assert(pos >=0 && pos < dnaSeq.length());
	dnaSeq.seq[pos] = base;
	setModified(true);
}

bool DNASequenceObject::checkConstraints(const GObjectConstraints* c) const	{
	const DNASequenceObjectConstraints* dnac = qobject_cast<const DNASequenceObjectConstraints*>(c);
	bool resultDNAConstraints = true;
	bool resultAlphabetType = true;

	if (dnac->exactSequenceSize != dnaSeq.length()) {
		resultDNAConstraints = false;
	}
	if (dnac->exactSequenceSize <= 0)	{
		resultDNAConstraints = true;
	}
	if (dnac->alphabetType != getAlphabet()->getType())	{
		resultAlphabetType = false;
	}
	if (dnac->alphabetType == DNAAlphabet_RAW)	{
		resultAlphabetType = true;
	}

	return (resultDNAConstraints && resultAlphabetType);
}

DNASequenceObjectConstraints::DNASequenceObjectConstraints(QObject* p) : GObjectConstraints(GObjectTypes::DNA_SEQUENCE, p){}




}//namespace


