/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_TASKS_H_
#define _GB2_PROJECT_TASKS_H_

#include <QUrl>

#include <core_api/Task.h>
#include <core_api/ProjectModel.h>

class QDomDocument;


namespace GB2 {

class Project;
class StateLock;

/// CloseProjectTask schema:
//	->CloseProjectTask (serial subtasks):
//		->SaveProjectTask
//		->UnregisterProjectTask	
class CloseProjectTask : public Task {
    Q_OBJECT

public:
	CloseProjectTask();
	virtual void prepare();
	ReportResult report();
};


/// OpenProjectTask schema:
//	->OpenProjectTask (serial subtasks):
//		->CloseProjectTask
//		->LoadProjectTask
//		->RegisterProjectTask (added after LoadProjectTask is successfully finished)

class LoadProjectTask;
class OpenProjectTask : public Task {
    Q_OBJECT

public:
	OpenProjectTask(const QString& url, const QString& name = QString::null);
    OpenProjectTask(const QList<QUrl>& list);
	
	virtual void prepare();
	ReportResult report();

protected:
	virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
	QString url;
	QString name;
    QList<QUrl> urlList;
	LoadProjectTask* loadProjectTask;
};


/// SaveProjectTask schema:
//	->SaveProjectTask
//		->SaveDocumentsTask
class SaveProjectTask : public Task {
    Q_OBJECT

public:
	SaveProjectTask(SaveProjectTaskKind k, Project* p = NULL, const QString& url = QString::null);
    ~SaveProjectTask();

	virtual void prepare();
	virtual void run();
	ReportResult report();
	
	static void saveProjectFile(TaskStateInfo& ts, Project* p, QString url = QString::null);
private:
	SaveProjectTaskKind k;
	StateLock* lock;
	Project* proj;
	QString url;
};


/// LoadProjectTask
class LoadProjectTask : public Task {
    Q_OBJECT

public:
	LoadProjectTask(const QString& url);
	~LoadProjectTask();

	virtual void run();
	ReportResult report();

	Project* getProject() const {return proj;}
	Project* detachProject() {Project* tmp = proj; proj = NULL; return tmp;}

	static void loadXMLProjectModel(const QString& url, TaskStateInfo& si, QDomDocument& doc);
	static Project* createProjectFromXMLModel(const QString& url, const QDomDocument& xmlDoc, TaskStateInfo& si);

private:
	Project* proj;
	QString url;
	QDomDocument* xmlDoc;
};


}//namespace

#endif
