/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MWMENU_MANAGER_IMPL_H_
#define _GB2_MWMENU_MANAGER_IMPL_H_

#include <core_api/MainWindow.h>

#include <QtGui/QMenuBar>
#include <QtGui/QMenu>
#include <QtCore/QEvent>

namespace GB2 {

class MWMenuManagerImpl: public MWMenuManager {
    Q_OBJECT
public:
	MWMenuManagerImpl(QObject* p, QMenuBar* mb);

	virtual QMenu* getTopLevelMenu(const QString& sysName) const ;

protected:
	bool eventFilter(QObject *obj, QEvent *event);
private:
	void unlinkTopLevelMenu(QMenu*);
	void linkTopLevelMenu(QMenu*);
	QMenu* createTopLevelMenu(const QString& sysName, const QString& title, const QString& afterSysName = QString::null);
	void updateTopLevelMenuVisibility(QMenu* m);
	QMenuBar* menuBar;
	QList<QMenu*> toplevelMenus;
};

}//namespace

#endif
