/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _IOADAPTER_REGISTRY_IMPL_H_
#define _IOADAPTER_REGISTRY_IMPL_H_

#include <core_api/IOAdapter.h>

namespace GB2 {

class IOAdapterRegistryImpl  : public IOAdapterRegistry {
public:
	IOAdapterRegistryImpl(QObject* p = NULL) : IOAdapterRegistry(p) {init();}
	
	virtual bool registerIOAdapter(IOAdapterFactory* io) ;

	virtual bool unregisterIOAdapter(IOAdapterFactory* io);

	virtual const QList<IOAdapterFactory*>& getRegisteredIOAdapters() const {return adapters;}

	virtual IOAdapterFactory* getIOAdapterFactoryById(IOAdapterId id) const;
	
private:
	void init();

	QList<IOAdapterFactory*> adapters;
};

}//namespace
#endif
