/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _UMUSCLE_TASK_LOCAL_STORAGE_
#define _UMUSCLE_TASK_LOCAL_STORAGE_

#include <QtCore/QThreadStorage>

class MuscleContext;

namespace GB2 {

class MuscleContextTLSRef {
public:
    MuscleContextTLSRef(MuscleContext* _ctx) : ctx(_ctx){}
    MuscleContext* ctx;
};

class TaskLocalData {
public:
    static MuscleContext* current();

    // initializes MuscleContext for the current thread
    static void initializeMuscleTLSContext();

    static void freeMuscleTLSContext();

private:
    static QThreadStorage<MuscleContextTLSRef*> tls;
};
} //namespace

#endif