/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_ARRAYWK_H_
#define _GB2_REPEAT_ARRAYWK_H_

#include "RepeatFinder.h"
#include "SArrayIndex.h"

#include <QThread>
#include <QLinkedList>
#include <QVector>

namespace GB2 {

class RepeatFinderSArrayWK : public RepeatFinder  {
public:
	RepeatFinderSArrayWK(const char* seqX, quint32 sizeX, const char* seqY, quint32 sizeY, DNAAlphabet* al,  quint32 w, quint32 k, quint32 threads);
	virtual ~RepeatFinderSArrayWK();

	RepeatResult* getResult(quint32 num);
	quint32 getNumResults();
	
	void startCalculation();
	void terminateCalculation();
    bool isRunning() const {return active;}

	
	bool blockingMode;
private:
	SArrayIndex* index;
	QMutex indexMutex;
	QMutex boundaryMutex;

	RepeatResult tmpEdge;

	const char *arraySeq;
	const char *searchSeq;
	quint32 ARRAY_SIZE;
	quint32 SEARCH_SIZE;
	quint32 ACTIVE_DIAGS;
	bool arrayIsX;
	quint32 q;
	quint32 nRunning;

	char unknownChar;
	bool active;
	
	

		
	/** final results*/
	QVector<RepeatResult> results;
	/** boundary results */
	QVector<quint32> bresultsA;
	QVector<quint32> bresultsS;
	QVector<quint32> bresultsL;
	QVector<quint32> bresultsD;
	
	quint32 nThreads;

	quint32 reportCounter;
	quint32 percentDone;
	
	/**each thread reports that percent done using this method*/
	inline void report();


	class WorkerThread : public SArrayIndex::SAISearchContext, public QThread {
	public:
		WorkerThread(RepeatFinderSArrayWK* owner, quint32 sStart, quint32 sEnd, quint32 _tid);
		virtual ~WorkerThread(){}
		void run();
		
		RepeatFinderSArrayWK* owner;
		const quint32 sStart;
		const quint32 sEnd;
		const quint32 tid;
	};

	friend class WorkerThread;
	void calculate(WorkerThread* t);
	QList<WorkerThread*> workers;
	void waitThreadsStop();
	void onFinished(WorkerThread* t);
	inline void addToResults(quint32 a, quint32 s, quint32 l, WorkerThread* t);
	inline void addToResults2(quint32 a, quint32 s, quint32 l);
	
	class RollingArray {
		QVector<quint32> buf;
		quint32 * data;
		int rollPos;
	public:
		const int size;
		RollingArray (int size);
		inline void set(int pos, int val);
		inline int get(int pos);
		inline void roll();
	};

	RollingArray* diagOffsets;
};

}//namespace
#endif 
