/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RepeatFinderPlugin.h"

#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAViewFactory.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/DetView.h>

#include <QtGui/QMenu>
#include <QtCore/QMap>
#include <QtGui/QAction>


namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    RepeatFinderPlugin* plug = new RepeatFinderPlugin();
    return plug;
}

RepeatFinderPlugin::RepeatFinderPlugin() : Plugin("repeatname", "repeatdesc") {
    viewCtx = new RepeatViewContext(this);
    viewCtx->init();
}

RepeatFinderPlugin::~RepeatFinderPlugin() {
    //printf("ORF deallocated!\n");
}

RepeatViewContext::RepeatViewContext(QObject* p) : 
GObjectViewWindowContext(p, AnnotatedDNAViewFactory::ID) {}

void RepeatViewContext::initViewContext(GObjectView* v) {
    Q_UNUSED(v);
//    QList<GObjectViewAction*> res;
//    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
//    assert(av);
//    GObjectViewAction* a = new GObjectViewAction(this, v, tr("find_repeats"));
//    connect(a, SIGNAL(triggered()), SLOT(sl_showDialog()));
//    res.append(a);
//    return res;
}

//void RepeatViewContext::buildMenu(GObjectView* v, QMenu* m) {
//    QList<GObjectViewAction*> list = actionsPerView.value(v);
//	assert(list.size()==1);
//    GObjectViewAction* a = list.first();
//    QMenu* analyseMenu = GUIUtils::findSubMenu(m, ADV_MENU_ANALYSE);
//    assert(analyseMenu);
//    analyseMenu->addAction(a);
//}

void RepeatViewContext::sl_showDialog() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    assert(av);
	printf("=======repeats=======\n");

    //ORFDialog d(av);
    //d.exec();
}

}//namespace
